/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.tree;

import com.google.common.collect.ImmutableList;
import com.misterpemodder.shulkerboxtooltip.impl.tree.ConfigNode;
import com.misterpemodder.shulkerboxtooltip.impl.tree.ValueConfigNode;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CategoryConfigNode<C>
implements ConfigNode<C> {
    private String name;
    private class_2561 title;
    private class_2561 tooltip;
    private ImmutableList<ConfigNode<C>> children;
    public static final class_2561 MULTIPLE_ERRORS = class_2561.method_43471((String)"shulkerboxtooltip.config.validator.multiple_errors");

    private CategoryConfigNode() {
    }

    public static <C> Builder<C> builder() {
        return new Builder();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public class_2561 getTitle() {
        return this.title;
    }

    @Override
    @Nullable
    public class_2561 getTooltip() {
        return this.tooltip;
    }

    @Override
    @Nullable
    public class_2561 getPrefix() {
        return null;
    }

    @Override
    public void resetToDefault() {
        this.children.forEach(ConfigNode::resetToDefault);
    }

    @Override
    public void resetToActive(C config) {
        this.children.forEach(child -> child.resetToActive(config));
    }

    @Override
    public boolean restartRequired(C config) {
        return this.children.stream().anyMatch(configNode -> configNode.restartRequired(config));
    }

    @Override
    public boolean isDefaultValue(C config) {
        return this.children.stream().allMatch(node -> node.isDefaultValue(config));
    }

    @Override
    public boolean isActiveValue(C config) {
        return this.children.stream().allMatch(node -> node.isActiveValue(config));
    }

    @Override
    @Nullable
    public class_2561 validate(C config) {
        class_2561 error = null;
        for (ConfigNode node : this.children) {
            class_2561 result = node.validate(config);
            if (result == null) continue;
            if (error != null) {
                return MULTIPLE_ERRORS;
            }
            error = result;
        }
        return error;
    }

    @NotNull
    public ImmutableList<ConfigNode<C>> getChildren() {
        return this.children;
    }

    @Override
    public void writeToNbt(C config, class_2487 compound) {
        class_2487 subTag = new class_2487();
        this.children.forEach(node -> node.writeToNbt(config, subTag));
        if (!subTag.method_33133()) {
            compound.method_10566(this.getName(), (class_2520)subTag);
        }
    }

    @Override
    public void readFromNbt(C config, class_2487 compound) {
        compound.method_10562(this.getName()).ifPresent(subTag -> this.children.forEach(node -> node.readFromNbt(config, (class_2487)subTag)));
    }

    @Override
    public void copy(C from, C to) {
        this.children.forEach(node -> node.copy(from, to));
    }

    @Override
    public void writeEditingToConfig(C config) {
        this.children.forEach(node -> node.writeEditingToConfig(config));
    }

    public static final class Builder<C> {
        private CategoryConfigNode<C> node = new CategoryConfigNode();
        private ImmutableList.Builder<ConfigNode<C>> childrenBuilder = ImmutableList.builder();

        private Builder() {
        }

        public Builder<C> name(String name) {
            this.node.name = name;
            return this;
        }

        public Builder<C> title(class_2561 title) {
            this.node.title = title;
            return this;
        }

        public Builder<C> tooltip(class_2561 tooltip) {
            this.node.tooltip = tooltip;
            return this;
        }

        public <T, V> Builder<C> value(UnaryOperator<ValueConfigNode.Builder<C, T, V>> valueBuilder) {
            this.childrenBuilder.add(((ValueConfigNode.Builder)valueBuilder.apply(ValueConfigNode.builder())).category(this.node).build());
            return this;
        }

        public Builder<C> category(UnaryOperator<Builder<C>> categoryBuilder) {
            this.childrenBuilder.add(((Builder)categoryBuilder.apply(new Builder<C>())).build());
            return this;
        }

        public CategoryConfigNode<C> build() {
            CategoryConfigNode<C> n = this.node;
            Objects.requireNonNull(n.name);
            Objects.requireNonNull(n.title);
            n.children = this.childrenBuilder.build();
            this.node = null;
            this.childrenBuilder = null;
            return n;
        }
    }
}

