/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.OptionalInt;
import net.minecraft.class_10712;
import net.minecraft.class_11585;
import net.minecraft.class_11596;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_7714;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import org.jspecify.annotations.Nullable;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.JadeUI;

public class ShelfProvider
implements StreamServerDataProvider<BlockAccessor, class_1799> {
    public static final ShelfProvider INSTANCE = new ShelfProvider();

    @Override
    public boolean shouldRequestData(BlockAccessor accessor) {
        if (accessor.showDetails()) {
            return false;
        }
        OptionalInt slot = ((class_11585)accessor.getBlock()).method_72611((class_3965)accessor.getHitResult(), (class_2350)accessor.getBlockState().method_11654((class_2769)class_2383.field_11177));
        if (slot.isEmpty()) {
            return false;
        }
        int i = slot.getAsInt();
        return !(accessor.getBlock() instanceof class_7714) || i >= class_7714.field_41308.size() || (Boolean)accessor.getBlockState().method_11654((class_2769)class_7714.field_41308.get(i)) != false;
    }

    @Override
    public @Nullable class_1799 streamData(BlockAccessor accessor) {
        int slot = ((class_11585)accessor.getBlock()).method_72611((class_3965)accessor.getHitResult(), accessor.getSide()).orElse(-1);
        if (slot == -1) {
            return null;
        }
        return ((class_11596)accessor.typedBlockEntity()).method_5438(slot);
    }

    @Override
    public class_9139<class_9129, class_1799> streamCodec() {
        return class_1799.field_49268;
    }

    @Override
    public class_2960 getUid() {
        return JadeIds.MC_SHELF;
    }

    public static class Client
    implements IBlockComponentProvider {
        public static final Client INSTANCE = new Client();

        private static class_1799 getHitBook(BlockAccessor accessor) {
            if (accessor.showDetails()) {
                return class_1799.field_8037;
            }
            return INSTANCE.decodeFromData(accessor).orElse(class_1799.field_8037);
        }

        @Override
        public @Nullable Element getIcon(BlockAccessor accessor, IPluginConfig config, @Nullable Element currentIcon) {
            class_1799 item = Client.getHitBook(accessor);
            return item.method_7960() ? null : JadeUI.item(item);
        }

        @Override
        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            class_1799 item = Client.getHitBook(accessor);
            if (item.method_7960()) {
                return;
            }
            tooltip.remove(JadeIds.UNIVERSAL_ITEM_STORAGE);
            tooltip.add((class_2561)IDisplayHelper.get().stripColor(item.method_7964()));
            if (item.method_57826(class_9334.field_49643)) {
                ArrayList list = Lists.newArrayList();
                class_10712 tooltipDisplay = (class_10712)item.method_58695(class_9334.field_56400, (Object)class_10712.field_56318);
                item.method_57369(class_9334.field_49643, class_1792.class_9635.method_59528((class_1937)accessor.getLevel()), tooltipDisplay, list::add, (class_1836)class_1836.field_41070);
                tooltip.addAll(list);
            }
        }

        @Override
        public int getDefaultPriority() {
            return ItemStorageProvider.BLOCK.getDefaultPriority() + 1;
        }

        @Override
        public class_2960 getUid() {
            return JadeIds.MC_SHELF;
        }
    }
}

