/*
 * Decompiled with CFR 0.152.
 */
package com.Influence.smoothboot.config;

import com.Influence.smoothboot.SmoothBoot;
import com.Influence.smoothboot.config.SmoothBootConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static Path getConfigPath() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        return configDir.resolve("smoothboot.json");
    }

    public static SmoothBootConfig readConfig() throws IOException {
        SmoothBootConfig config;
        Path configPath = ConfigHandler.getConfigPath();
        SmoothBoot.LOGGER.debug("Config path: " + String.valueOf(configPath));
        Path configDir = configPath.getParent();
        if (configDir != null && !Files.exists(configDir, new LinkOption[0])) {
            try {
                Files.createDirectories(configDir, new FileAttribute[0]);
                SmoothBoot.LOGGER.debug("Created config directory: " + String.valueOf(configDir));
            }
            catch (IOException e) {
                SmoothBoot.LOGGER.error("Failed to create config directory: " + e.getMessage());
            }
        }
        if (!Files.exists(configPath, new LinkOption[0])) {
            SmoothBoot.LOGGER.debug("Config file not found, creating default config");
            SmoothBootConfig defaultConfig = new SmoothBootConfig();
            ConfigHandler.writeConfig(defaultConfig);
            return defaultConfig;
        }
        try (FileReader reader = new FileReader(configPath.toFile());){
            config = (SmoothBootConfig)GSON.fromJson((Reader)reader, SmoothBootConfig.class);
            if (config == null) {
                throw new NullPointerException("Config is null");
            }
            config.validate();
            ConfigHandler.writeConfig(config);
            SmoothBoot.LOGGER.debug("Config loaded successfully: " + String.valueOf(config));
        }
        catch (JsonParseException | IOException | NullPointerException e) {
            SmoothBoot.LOGGER.error("Error reading config file, creating new one: " + e.getMessage());
            config = new SmoothBootConfig();
            ConfigHandler.writeConfig(config);
            SmoothBoot.LOGGER.debug("New config file created");
        }
        return config;
    }

    public static void writeConfig(SmoothBootConfig config) throws IOException {
        Path configPath = ConfigHandler.getConfigPath();
        Path configDir = configPath.getParent();
        if (configDir != null && !Files.exists(configDir, new LinkOption[0])) {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        try (FileWriter writer = new FileWriter(configPath.toFile());){
            GSON.toJson((Object)config, (Appendable)writer);
        }
    }
}

