/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.common.db;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.coordshud.common.cache.PlayerCache;
import me.jfenn.coordshud.common.db.PlayerRecord;
import me.jfenn.coordshud.common.db.PlayerTable;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Column;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Expression;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.OpBuilderKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ResultRow;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.UpsertStatement;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.Database;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.JdbcTransaction;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.QueriesKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.transactions.TransactionManagerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\t\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lme/jfenn/coordshud/common/db/PlayerDao;", "", "Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/Database;", "db", "Lme/jfenn/coordshud/common/cache/PlayerCache;", "cache", "<init>", "(Lorg/jetbrains/exposed/v1/jdbc/Database;Lme/jfenn/coordshud/common/cache/PlayerCache;)V", "Ljava/util/UUID;", "uuid", "Lme/jfenn/coordshud/common/db/PlayerRecord;", "getPlayer", "(Ljava/util/UUID;)Lme/jfenn/coordshud/common/db/PlayerRecord;", "", "isEnabled", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/UpsertStatement;", "", "setEnabled", "(Ljava/util/UUID;Z)Lorg/jetbrains/exposed/v1/core/statements/UpsertStatement;", "", "format", "setFormat", "(Ljava/util/UUID;Ljava/lang/String;)Lorg/jetbrains/exposed/v1/core/statements/UpsertStatement;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/Database;", "Lme/jfenn/coordshud/common/cache/PlayerCache;", "coordshud-common"})
public final class PlayerDao {
    @NotNull
    private final Database db;
    @NotNull
    private final PlayerCache cache;

    public PlayerDao(@NotNull Database db, @NotNull PlayerCache cache) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.db = db;
        this.cache = cache;
    }

    @NotNull
    public final PlayerRecord getPlayer(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Object object = this.cache.getPlayers().get((Object)uuid, () -> PlayerDao.getPlayer$lambda$2(this, uuid));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (PlayerRecord)object;
    }

    @NotNull
    public final UpsertStatement<Long> setEnabled(@NotNull UUID uuid, boolean isEnabled) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Object t = TransactionManagerKt.transaction(this.db, arg_0 -> PlayerDao.setEnabled$lambda$4(uuid, isEnabled, arg_0));
        UpsertStatement it = (UpsertStatement)t;
        boolean bl = false;
        this.cache.remove(uuid);
        return (UpsertStatement)t;
    }

    @NotNull
    public final UpsertStatement<Long> setFormat(@NotNull UUID uuid, @Nullable String format) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Object t = TransactionManagerKt.transaction(this.db, arg_0 -> PlayerDao.setFormat$lambda$7(uuid, format, arg_0));
        UpsertStatement it = (UpsertStatement)t;
        boolean bl = false;
        this.cache.remove(uuid);
        return (UpsertStatement)t;
    }

    private static final PlayerRecord getPlayer$lambda$2$lambda$1(UUID $uuid, JdbcTransaction $this$transaction) {
        PlayerRecord playerRecord;
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Expression[] expressionArray = new Expression[]{PlayerTable.INSTANCE.isEnabled()};
        ResultRow resultRow = (ResultRow)CollectionsKt.singleOrNull((Iterable)QueriesKt.select(PlayerTable.INSTANCE, (Expression)PlayerTable.INSTANCE.getFormat(), expressionArray).where(OpBuilderKt.eq(PlayerTable.INSTANCE.getUuid(), $uuid)));
        if (resultRow != null) {
            ResultRow it = resultRow;
            boolean bl = false;
            playerRecord = new PlayerRecord($uuid, (Boolean)it.get(PlayerTable.INSTANCE.isEnabled()), (String)it.get(PlayerTable.INSTANCE.getFormat()));
        } else {
            Function0<Boolean> function0 = PlayerTable.INSTANCE.isEnabled().getDefaultValueFun();
            Intrinsics.checkNotNull(function0);
            Boolean bl = (Boolean)function0.invoke();
            Function0<String> function02 = PlayerTable.INSTANCE.getFormat().getDefaultValueFun();
            Intrinsics.checkNotNull(function02);
            playerRecord = new PlayerRecord($uuid, bl, (String)function02.invoke());
        }
        return playerRecord;
    }

    private static final PlayerRecord getPlayer$lambda$2(PlayerDao this$0, UUID $uuid) {
        return (PlayerRecord)TransactionManagerKt.transaction(this$0.db, arg_0 -> PlayerDao.getPlayer$lambda$2$lambda$1($uuid, arg_0));
    }

    private static final Unit setEnabled$lambda$4$lambda$3(UUID $uuid, boolean $isEnabled, PlayerTable $this$upsert, UpsertStatement it) {
        Intrinsics.checkNotNullParameter((Object)$this$upsert, (String)"$this$upsert");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set(PlayerTable.INSTANCE.getUuid(), $uuid);
        it.set(PlayerTable.INSTANCE.isEnabled(), $isEnabled);
        return Unit.INSTANCE;
    }

    private static final UpsertStatement setEnabled$lambda$4(UUID $uuid, boolean $isEnabled, JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        return QueriesKt.upsert$default(PlayerTable.INSTANCE, new Column[0], null, null, null, (arg_0, arg_1) -> PlayerDao.setEnabled$lambda$4$lambda$3($uuid, $isEnabled, arg_0, arg_1), 14, null);
    }

    private static final Unit setFormat$lambda$7$lambda$6(UUID $uuid, String $format, PlayerTable $this$upsert, UpsertStatement it) {
        Intrinsics.checkNotNullParameter((Object)$this$upsert, (String)"$this$upsert");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set(PlayerTable.INSTANCE.getUuid(), $uuid);
        it.set(PlayerTable.INSTANCE.getFormat(), $format);
        return Unit.INSTANCE;
    }

    private static final UpsertStatement setFormat$lambda$7(UUID $uuid, String $format, JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        return QueriesKt.upsert$default(PlayerTable.INSTANCE, new Column[0], null, null, null, (arg_0, arg_1) -> PlayerDao.setFormat$lambda$7$lambda$6($uuid, $format, arg_0, arg_1), 14, null);
    }
}

