/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/IntegerColumnType;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ColumnType;", "", "<init>", "()V", "", "sqlType", "()Ljava/lang/String;", "", "value", "valueFromDB", "(Ljava/lang/Object;)Ljava/lang/Integer;", "exposed-core"})
public final class IntegerColumnType
extends ColumnType<Integer> {
    public IntegerColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().integerType();
    }

    @Override
    @NotNull
    public Integer valueFromDB(@NotNull Object value) {
        int n;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof Integer) {
            n = ((Number)value).intValue();
        } else if (object instanceof Number) {
            n = ((Number)value).intValue();
        } else if (object instanceof String) {
            n = Integer.parseInt((String)value);
        } else {
            throw new IllegalStateException(("Unexpected value of type Int: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return n;
    }
}

