/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core.datetime;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.datetime.format.DateTimeFormat;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.IColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.IDateColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Version;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.datetime.InstantColumnTypeKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.datetime.LocalDateTimeColumnTypeKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.api.RowApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.transactions.CoreTransactionManager;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.H2Dialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.H2Kt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.MariaDBDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.MysqlDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.OracleDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.PostgreSQLDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.SQLiteDialect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00028\u0000H&\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u0007H&\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001c\u0010\u0010\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\b\u00028\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\tJ\u0017\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J!\u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001c\u0010\u001e\u001a\u00020\u00122\b\u0010\u0006\u001a\u0004\b\u00028\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001e\u0010\u0017J\u001c\u0010\u001f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\b\u00028\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010\u0011R\u001a\u0010!\u001a\u00020 8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006%"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/datetime/InstantColumnType;", "T", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ColumnType;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/IDateColumnType;", "<init>", "()V", "value", "Lkotlin/time/Instant;", "toInstant", "(Ljava/lang/Object;)Lkotlin/time/Instant;", "instant", "fromInstant", "(Lkotlin/time/Instant;)Ljava/lang/Object;", "", "sqlType", "()Ljava/lang/String;", "nonNullValueToString", "(Ljava/lang/Object;)Ljava/lang/String;", "", "instantValueFromDB", "parseInstantFromString", "(Ljava/lang/String;)Lkotlin/time/Instant;", "valueFromDB", "(Ljava/lang/Object;)Ljava/lang/Object;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/RowApi;", "rs", "", "index", "readObject", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/RowApi;I)Ljava/lang/Object;", "notNullValueToDB", "nonNullValueAsDefaultString", "", "hasTimePart", "Z", "getHasTimePart", "()Z", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nInstantColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstantColumnType.kt\norg/jetbrains/exposed/v1/core/datetime/InstantColumnType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public abstract class InstantColumnType<T>
extends ColumnType<T>
implements IDateColumnType {
    private final boolean hasTimePart;

    public InstantColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    @NotNull
    public abstract kotlin.time.Instant toInstant(T var1);

    public abstract T fromInstant(@NotNull kotlin.time.Instant var1);

    @Override
    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().timestampType();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull T value) {
        String string;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        kotlinx.datetime.LocalDateTime localDateTime = TimeZoneKt.toLocalDateTime((kotlin.time.Instant)this.toInstant(value), (TimeZone)TimeZone.Companion.currentSystemDefault());
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof MysqlDialect) {
            DateTimeFormat formatter = ((MysqlDialect)dialect).isFractionDateTimeSupported() ? InstantColumnTypeKt.access$getMYSQL_TIMESTAMP_FRACTION_FORMAT() : InstantColumnTypeKt.access$getMYSQL_TIMESTAMP_FORMAT();
            string = '\'' + formatter.format((Object)localDateTime) + '\'';
        } else if (dialect instanceof SQLiteDialect) {
            string = '\'' + InstantColumnTypeKt.access$getORACLE_SQLITE_TIMESTAMP_FORMAT().format((Object)localDateTime) + '\'';
        } else if (dialect instanceof OracleDialect) {
            String formatted = InstantColumnTypeKt.access$getORACLE_SQLITE_TIMESTAMP_FORMAT().format((Object)localDateTime);
            string = "TO_TIMESTAMP('" + formatted + "', 'YYYY-MM-DD HH24:MI:SS.FF3')";
        } else {
            string = '\'' + InstantColumnTypeKt.access$getDEFAULT_TIMESTAMP_FORMAT$p().format((Object)localDateTime) + '\'';
        }
        return string;
    }

    private final kotlin.time.Instant instantValueFromDB(Object value) {
        kotlin.time.Instant instant;
        Object object = value;
        if (object instanceof Timestamp) {
            instant = kotlin.time.Instant.Companion.fromEpochSeconds(((Timestamp)value).getTime() / (long)1000, ((Timestamp)value).getNanos());
        } else if (object instanceof String) {
            instant = this.parseInstantFromString((String)value);
        } else if (object instanceof LocalDateTime) {
            long it = ((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            boolean bl = false;
            instant = kotlin.time.Instant.Companion.fromEpochMilliseconds(it);
        } else {
            instant = this.instantValueFromDB(value.toString());
        }
        return instant;
    }

    private final kotlin.time.Instant parseInstantFromString(String value) {
        kotlin.time.Instant instant;
        try {
            Instant javaInstant = Instant.parse(value);
            instant = kotlin.time.Instant.Companion.fromEpochSeconds(javaInstant.getEpochSecond(), (long)javaInstant.getNano());
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Failed to parse instant from string: " + value, e);
        }
        return instant;
    }

    @Override
    public T valueFromDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fromInstant(this.instantValueFromDB(value));
    }

    @Override
    @Nullable
    public Object readObject(@NotNull RowApi rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return rs.getObject(index, Timestamp.class, (IColumnType)this);
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        kotlinx.datetime.LocalDateTime localDateTime = TimeZoneKt.toLocalDateTime((kotlin.time.Instant)this.toInstant(value), (TimeZone)TimeZone.Companion.currentSystemDefault());
        return dialect instanceof SQLiteDialect ? InstantColumnTypeKt.access$getORACLE_SQLITE_TIMESTAMP_FORMAT().format((Object)localDateTime) : (dialect instanceof MysqlDialect && !(dialect instanceof MariaDBDialect) && !Version.covers$default(CoreTransactionManager.INSTANCE.currentTransaction().getDb().getVersion(), 8, 0, 0, 4, null) ? (((MysqlDialect)dialect).isFractionDateTimeSupported() ? InstantColumnTypeKt.access$getMYSQL_TIMESTAMP_FRACTION_FORMAT().format((Object)localDateTime) : InstantColumnTypeKt.access$getMYSQL_TIMESTAMP_FORMAT().format((Object)localDateTime)) : LocalDateTimeColumnTypeKt.toSqlTimestamp$default(localDateTime, null, 1, null));
    }

    @Override
    @NotNull
    public String nonNullValueAsDefaultString(@NotNull T value) {
        String string;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        kotlinx.datetime.LocalDateTime localDateTime = TimeZoneKt.toLocalDateTime((kotlin.time.Instant)this.toInstant(value), (TimeZone)TimeZone.Companion.currentSystemDefault());
        if (dialect instanceof PostgreSQLDialect) {
            String formatted = InstantColumnTypeKt.access$getORACLE_SQLITE_TIMESTAMP_FORMAT().format((Object)localDateTime);
            char[] cArray = new char[]{'0'};
            String string2 = StringsKt.trimEnd((String)formatted, (char[])cArray);
            cArray = new char[]{'.'};
            string = '\'' + StringsKt.trimEnd((String)string2, (char[])cArray) + "'::timestamp without time zone";
        } else if (H2Kt.getH2Mode(dialect) == H2Dialect.H2CompatibilityMode.Oracle) {
            String formatted = InstantColumnTypeKt.access$getORACLE_SQLITE_TIMESTAMP_FORMAT().format((Object)localDateTime);
            char[] cArray = new char[]{'0'};
            String string3 = StringsKt.trimEnd((String)formatted, (char[])cArray);
            cArray = new char[]{'.'};
            string = '\'' + StringsKt.trimEnd((String)string3, (char[])cArray) + '\'';
        } else {
            string = super.nonNullValueAsDefaultString(value);
        }
        return string;
    }
}

