/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.api;

import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.InternalApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.api.RowApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.ColumnMetadata;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.H2Dialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.H2Kt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.MariaDBDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.MysqlDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.OracleDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.SQLServerDialect;
import org.jetbrains.annotations.NotNull;

@InternalApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\t\u001a\u00020\b*\u00020\u00042\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\t\u0010\nJ6\u0010\u000f\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0019\b\u0002\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\u0002\b\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J+\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u0015\u0010\u0019\u001a\u0004\u0018\u00010\u0006*\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/ExposedMetadataUtils;", "", "<init>", "()V", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/RowApi;", "", "", "prefetchedColumnTypes", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/ColumnMetadata;", "asColumnMetadata", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/RowApi;Ljava/util/Map;)Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/ColumnMetadata;", "field", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "transform", "getStringOrThrow", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/RowApi;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/String;", "result", "getColumnType", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/RowApi;Ljava/util/Map;)Ljava/lang/String;", "columnType", "normalizedColumnType", "(Ljava/lang/String;)Ljava/lang/String;", "defaultValue", "sanitizedDefault", "extractNullAndStringFromDefaultValue", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nExposedMetadataUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExposedMetadataUtils.kt\norg/jetbrains/exposed/v1/core/statements/api/ExposedMetadataUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
public final class ExposedMetadataUtils {
    @NotNull
    public static final ExposedMetadataUtils INSTANCE = new ExposedMetadataUtils();

    private ExposedMetadataUtils() {
    }

    @NotNull
    public final ColumnMetadata asColumnMetadata(@NotNull RowApi $this$asColumnMetadata, @NotNull Map<String, String> prefetchedColumnTypes) {
        String string;
        Integer n;
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)$this$asColumnMetadata, (String)"<this>");
        Intrinsics.checkNotNullParameter(prefetchedColumnTypes, (String)"prefetchedColumnTypes");
        String string4 = $this$asColumnMetadata.getObject("COLUMN_DEF", String.class);
        if (string4 != null && (string4 = string4.toString()) != null) {
            String it = string4;
            boolean bl = false;
            string3 = INSTANCE.sanitizedDefault(it);
        } else {
            string3 = null;
        }
        String defaultDbValue = string3;
        String string5 = $this$asColumnMetadata.getObject("IS_AUTOINCREMENT", String.class);
        boolean autoIncrement = Intrinsics.areEqual((Object)(string5 != null ? string5.toString() : null), (Object)"YES");
        Object object = $this$asColumnMetadata.getObject("DATA_TYPE");
        int type = object != null && (object = object.toString()) != null ? Integer.parseInt((String)object) : 0;
        String name = ExposedMetadataUtils.getStringOrThrow$default(this, $this$asColumnMetadata, "COLUMN_NAME", null, 2, null);
        Object[] bl = new String[]{"true", "1"};
        Iterable iterable = CollectionsKt.listOf((Object[])bl);
        Object object2 = $this$asColumnMetadata.getObject("NULLABLE");
        if (object2 != null && (object2 = object2.toString()) != null) {
            String string6 = ((String)object2).toLowerCase(Locale.ROOT);
            string2 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
        } else {
            string2 = null;
        }
        boolean nullable = CollectionsKt.contains((Iterable)iterable, string2);
        Object object3 = $this$asColumnMetadata.getObject("COLUMN_SIZE");
        Integer it = n = object3 != null && (object3 = object3.toString()) != null ? Integer.valueOf(Integer.parseInt((String)object3)) : null;
        boolean bl2 = false;
        Integer n2 = it;
        Integer size = n2 == null || n2 != 0 ? n : null;
        Object object4 = $this$asColumnMetadata.getObject("DECIMAL_DIGITS");
        Integer it2 = it = object4 != null && (object4 = object4.toString()) != null ? Integer.valueOf(Integer.parseInt((String)object4)) : null;
        boolean bl32 = false;
        Integer n3 = it2;
        Integer scale = n3 == null || n3 != 0 ? it : null;
        String sqlType = this.getColumnType($this$asColumnMetadata, prefetchedColumnTypes);
        String string7 = name;
        int n4 = type;
        String string8 = sqlType;
        boolean bl4 = nullable;
        Integer n5 = size;
        Integer n6 = scale;
        boolean bl5 = autoIncrement;
        String string9 = defaultDbValue;
        if (string9 != null) {
            String string10;
            String bl32 = string10 = string9;
            boolean bl6 = bl5;
            Integer n7 = n6;
            Integer n8 = n5;
            boolean bl7 = bl4;
            String string11 = string8;
            int n9 = n4;
            String string12 = string7;
            boolean bl8 = false;
            boolean bl9 = !autoIncrement;
            string7 = string12;
            n4 = n9;
            string8 = string11;
            bl4 = bl7;
            n5 = n8;
            n6 = n7;
            bl5 = bl6;
            string = bl9 ? string10 : null;
        } else {
            string = null;
        }
        String string13 = string;
        boolean bl10 = bl5;
        Integer n10 = n6;
        Integer n11 = n5;
        boolean bl11 = bl4;
        String string14 = string8;
        int n12 = n4;
        String string15 = string7;
        return new ColumnMetadata(string15, n12, string14, bl11, n11, n10, bl10, string13);
    }

    public static /* synthetic */ ColumnMetadata asColumnMetadata$default(ExposedMetadataUtils exposedMetadataUtils, RowApi rowApi, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        return exposedMetadataUtils.asColumnMetadata(rowApi, map);
    }

    private final String getStringOrThrow(RowApi $this$getStringOrThrow, String field, Function1<? super String, String> transform) {
        String string;
        String string2;
        String string3 = $this$getStringOrThrow.getObject(field, String.class);
        if (string3 == null || (string2 = string3.toString()) == null || (string = (String)transform.invoke((Object)string2)) == null) {
            throw new IllegalStateException(("Object retrieved from field " + field + " in current data row is null").toString());
        }
        return string;
    }

    static /* synthetic */ String getStringOrThrow$default(ExposedMetadataUtils exposedMetadataUtils, RowApi rowApi, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = ExposedMetadataUtils::getStringOrThrow$lambda$4;
        }
        return exposedMetadataUtils.getStringOrThrow(rowApi, string, (Function1<? super String, String>)function1);
    }

    private final String getColumnType(RowApi result, Map<String, String> prefetchedColumnTypes) {
        String string;
        Integer dataType;
        if (!(DatabaseDialectKt.getCurrentDialect() instanceof H2Dialect)) {
            return "";
        }
        String columnName = ExposedMetadataUtils.getStringOrThrow$default(this, result, "COLUMN_NAME", null, 2, null);
        String string2 = prefetchedColumnTypes.get(columnName);
        if (string2 == null) {
            string2 = this.getStringOrThrow(result, "TYPE_NAME", (Function1<? super String, String>)((Function1)ExposedMetadataUtils::getColumnType$lambda$5));
        }
        String columnType = string2;
        Object object = result.getObject("DATA_TYPE");
        Integer n = dataType = object != null && (object = object.toString()) != null ? Integer.valueOf(Integer.parseInt((String)object)) : null;
        int n2 = 2003;
        if (n != null && n == n2) {
            String baseType = StringsKt.substringBefore$default((String)columnType, (String)" ARRAY", null, (int)2, null);
            string = this.normalizedColumnType(baseType) + StringsKt.replaceBefore$default((String)columnType, (String)" ARRAY", (String)"", null, (int)4, null);
        } else {
            string = this.normalizedColumnType(columnType);
        }
        return string;
    }

    private final String normalizedColumnType(String columnType) {
        String string;
        H2Dialect.H2CompatibilityMode h2Mode = H2Kt.getH2Mode(DatabaseDialectKt.getCurrentDialect());
        CharSequence charSequence = columnType;
        if (new Regex("CHARACTER VARYING(?:\\(\\d+\\))?").matches(charSequence)) {
            H2Dialect.H2CompatibilityMode h2CompatibilityMode = h2Mode;
            string = (h2CompatibilityMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[h2CompatibilityMode.ordinal()]) == 1 ? StringsKt.replace$default((String)columnType, (String)"CHARACTER VARYING", (String)"VARCHAR2", (boolean)false, (int)4, null) : StringsKt.replace$default((String)columnType, (String)"CHARACTER VARYING", (String)"VARCHAR", (boolean)false, (int)4, null);
        } else {
            charSequence = columnType;
            if (new Regex("CHARACTER(?:\\(\\d+\\))?").matches(charSequence)) {
                string = StringsKt.replace$default((String)columnType, (String)"CHARACTER", (String)"CHAR", (boolean)false, (int)4, null);
            } else {
                charSequence = columnType;
                if (new Regex("BINARY VARYING(?:\\(\\d+\\))?").matches(charSequence)) {
                    H2Dialect.H2CompatibilityMode h2CompatibilityMode = h2Mode;
                    switch (h2CompatibilityMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[h2CompatibilityMode.ordinal()]) {
                        case 2: {
                            string = "bytea";
                            break;
                        }
                        case 1: {
                            string = StringsKt.replace$default((String)columnType, (String)"BINARY VARYING", (String)"RAW", (boolean)false, (int)4, null);
                            break;
                        }
                        default: {
                            string = StringsKt.replace$default((String)columnType, (String)"BINARY VARYING", (String)"VARBINARY", (boolean)false, (int)4, null);
                            break;
                        }
                    }
                } else if (Intrinsics.areEqual((Object)columnType, (Object)"BOOLEAN")) {
                    H2Dialect.H2CompatibilityMode h2CompatibilityMode = h2Mode;
                    string = (h2CompatibilityMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[h2CompatibilityMode.ordinal()]) == 3 ? "BIT" : columnType;
                } else {
                    string = Intrinsics.areEqual((Object)columnType, (Object)"BINARY LARGE OBJECT") ? "BLOB" : (Intrinsics.areEqual((Object)columnType, (Object)"CHARACTER LARGE OBJECT") ? "CLOB" : (Intrinsics.areEqual((Object)columnType, (Object)"INTEGER") && h2Mode != H2Dialect.H2CompatibilityMode.Oracle ? "INT" : columnType));
                }
            }
        }
        return string;
    }

    private final String sanitizedDefault(String defaultValue) {
        String string;
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        H2Dialect.H2CompatibilityMode h2Mode = H2Kt.getH2Mode(dialect);
        if (dialect instanceof MariaDBDialect || h2Mode == H2Dialect.H2CompatibilityMode.MariaDB) {
            if (StringsKt.startsWith$default((String)defaultValue, (String)"b'", (boolean)false, (int)2, null)) {
                char[] cArray = new char[]{'\''};
                string = StringsKt.trim((String)StringsKt.substringAfter$default((String)defaultValue, (String)"b'", null, (int)2, null), (char[])cArray);
            } else {
                string = this.extractNullAndStringFromDefaultValue(defaultValue);
            }
        } else if (dialect instanceof MysqlDialect && Intrinsics.areEqual((Object)defaultValue, (Object)"NULL")) {
            string = defaultValue;
        } else if (dialect instanceof MysqlDialect || h2Mode == H2Dialect.H2CompatibilityMode.MySQL) {
            if (StringsKt.startsWith$default((String)defaultValue, (String)"b'", (boolean)false, (int)2, null)) {
                char[] cArray = new char[]{'\''};
                string = StringsKt.trim((String)StringsKt.substringAfter$default((String)defaultValue, (String)"b'", null, (int)2, null), (char[])cArray);
            } else {
                string = this.extractNullAndStringFromDefaultValue(defaultValue);
            }
        } else if (dialect instanceof SQLServerDialect) {
            char[] cArray = new char[]{'(', ')'};
            string = this.extractNullAndStringFromDefaultValue(StringsKt.trim((String)defaultValue, (char[])cArray));
        } else {
            string = dialect instanceof OracleDialect ? this.extractNullAndStringFromDefaultValue(((Object)StringsKt.trim((CharSequence)defaultValue)).toString()) : this.extractNullAndStringFromDefaultValue(defaultValue);
        }
        return string;
    }

    private final String extractNullAndStringFromDefaultValue(String $this$extractNullAndStringFromDefaultValue) {
        String string;
        if (StringsKt.startsWith$default((String)$this$extractNullAndStringFromDefaultValue, (String)"NULL", (boolean)false, (int)2, null)) {
            string = null;
        } else if (StringsKt.startsWith$default((CharSequence)$this$extractNullAndStringFromDefaultValue, (char)'\'', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)$this$extractNullAndStringFromDefaultValue, (char)'\'', (boolean)false, (int)2, null)) {
            char[] cArray = new char[]{'\''};
            string = StringsKt.trim((String)$this$extractNullAndStringFromDefaultValue, (char[])cArray);
        } else {
            string = $this$extractNullAndStringFromDefaultValue;
        }
        return string;
    }

    private static final String getStringOrThrow$lambda$4(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<this>");
        return string;
    }

    private static final String getColumnType$lambda$5(String $this$getStringOrThrow) {
        Intrinsics.checkNotNullParameter((Object)$this$getStringOrThrow, (String)"$this$getStringOrThrow");
        String string = $this$getStringOrThrow.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[H2Dialect.H2CompatibilityMode.values().length];
            try {
                nArray[H2Dialect.H2CompatibilityMode.Oracle.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2Dialect.H2CompatibilityMode.PostgreSQL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2Dialect.H2CompatibilityMode.SQLServer.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

