/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus;

import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import xaero.hud.HudSession;
import xaero.map.MapProcessor;
import xaero.map.WorldMapSession;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.world.MapWorld;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ClientPlaySessionFinalizedEvent;
import xaeroplus.feature.render.DrawManager;
import xaeroplus.settings.Settings;

public class Globals {
    public static final DrawManager drawManager = new DrawManager();
    public static final class_2960 guiTextures = class_2960.method_60655((String)"xaeroplus", (String)"gui/xpgui.png");
    public static boolean nullOverworldDimensionFolder = false;
    public static Settings.DataFolderResolutionMode dataFolderResolutionMode = Settings.DataFolderResolutionMode.IP;
    public static int minimapScaleMultiplier = 1;
    public static int minimapSizeMultiplier = 1;
    public static boolean shouldResetFBO = false;
    public static boolean minimapSettingsInitialized = false;
    public static boolean switchingDimension = false;
    public static boolean disableDrawCullingOverride = false;
    public static final boolean atomicMoveAvailable = Globals.testAtomicMoveAvailable();
    public static boolean transparentWmBgApplyMapBlend = false;
    public static boolean transparentWmBgApplyMapFrameBlend = false;
    public static boolean bypassVertexCountLimit = false;
    public static ByteArrayOutputStream zipFastByteBuffer = new ByteArrayOutputStream();
    public static final Supplier<ExecutorService> cacheRefreshExecutorService = Suppliers.memoize(() -> Executors.newFixedThreadPool(Math.max(1, Math.min(Runtime.getRuntime().availableProcessors() / 2, 2)), new ThreadFactoryBuilder().setNameFormat("XaeroPlus-Cache-Refresh-%d").setUncaughtExceptionHandler((t, e) -> XaeroPlus.LOGGER.error("Caught unhandled exception in cache refresh executor", e)).setDaemon(true).build()));
    public static final Supplier<ExecutorService> moduleExecutorService = Suppliers.memoize(() -> Executors.newFixedThreadPool(Math.max(1, Math.min(Runtime.getRuntime().availableProcessors() / 2, 2)), new ThreadFactoryBuilder().setNameFormat("XaeroPlus-Module-%d").setUncaughtExceptionHandler((t, e) -> XaeroPlus.LOGGER.error("Caught unhandled exception in module executor", e)).setDaemon(true).build()));

    public static class_5321<class_1937> getCurrentDimensionId() {
        try {
            class_5321 dim = XaeroWorldMapCore.currentSession.getMapProcessor().getMapWorld().getCurrentDimensionId();
            if (dim == null) {
                return class_1937.field_25179;
            }
            return dim;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed getting current dimension id", (Throwable)e);
            return class_1937.field_25179;
        }
    }

    public static void initStickySettings() {
        nullOverworldDimensionFolder = Settings.REGISTRY.nullOverworldDimensionFolder.get();
        dataFolderResolutionMode = Settings.REGISTRY.dataFolderResolutionMode.get();
        minimapScaleMultiplier = Settings.REGISTRY.minimapScaleMultiplierSetting.getAsInt();
        minimapSizeMultiplier = Settings.REGISTRY.minimapSizeMultiplierSetting.getAsInt();
        XaeroPlus.EVENT_BUS.registerConsumer(e -> {
            nullOverworldDimensionFolder = Settings.REGISTRY.nullOverworldDimensionFolder.get();
            dataFolderResolutionMode = Settings.REGISTRY.dataFolderResolutionMode.get();
        }, ClientPlaySessionFinalizedEvent.class);
    }

    public static void switchToDimension(class_5321<class_1937> newDimId) {
        if (newDimId == null) {
            return;
        }
        try {
            WorldMapSession session = XaeroWorldMapCore.currentSession;
            if (session == null) {
                return;
            }
            MapProcessor mapProcessor = session.getMapProcessor();
            if (mapProcessor == null) {
                return;
            }
            MapWorld mapWorld = mapProcessor.getMapWorld();
            if (mapWorld == null) {
                return;
            }
            mapWorld.setCustomDimensionId(newDimId);
            mapProcessor.checkForWorldUpdate();
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed switching to dimension: {}", newDimId, (Object)e);
        }
    }

    public static void setNullOverworldDimFolderIfAble(boolean b) {
        try {
            WorldMapSession currentWMSession = XaeroWorldMapCore.currentSession;
            HudSession currentMMSession = HudSession.getCurrentSession();
            if (currentWMSession != null || currentMMSession != null) {
                return;
            }
            nullOverworldDimensionFolder = b;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed setting nullOverworldDimensionFolder", (Throwable)e);
        }
    }

    public static void setDataFolderResolutionModeIfAble(Settings.DataFolderResolutionMode mode) {
        try {
            WorldMapSession currentWMSession = XaeroWorldMapCore.currentSession;
            HudSession currentMMSession = HudSession.getCurrentSession();
            if (currentWMSession != null || currentMMSession != null) {
                return;
            }
            dataFolderResolutionMode = mode;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed setting data folder resolution mode", (Throwable)e);
        }
    }

    private static boolean testAtomicMoveAvailable() {
        try {
            File tempFile = File.createTempFile("xp-atomic-move-test", "test");
            tempFile.deleteOnExit();
            File tempFile2 = File.createTempFile("xp-atomic-move-test", "test");
            tempFile2.deleteOnExit();
            Files.move(tempFile.toPath(), tempFile2.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            XaeroPlus.LOGGER.debug("Atomic move supported");
            return true;
        }
        catch (AtomicMoveNotSupportedException e) {
            XaeroPlus.LOGGER.debug("Atomic move not supported", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.debug("Failed testing atomic move support", (Throwable)e);
            return false;
        }
    }
}

