/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.extensions;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Hashtable;
import xaero.map.file.RegionDetection;
import xaero.map.highlight.RegionHighlightExistenceTracker;
import xaero.map.region.MapLayer;
import xaero.map.util.linked.ILinkedChainNode;
import xaero.map.util.linked.LinkedChain;
import xaero.map.world.MapDimension;
import xaeroplus.util.ChunkUtils;

public class OptimizedMapLayer
extends MapLayer {
    private final MapDimension mapDimension;
    private final Long2ObjectOpenHashMap<RegionDetection> detectedRegions0;
    private final Long2ObjectOpenHashMap<RegionDetection> completeDetectedRegions0;
    private final LinkedChain<RegionDetection> completeDetectedRegionsLinked;

    public OptimizedMapLayer(MapDimension mapDimension, RegionHighlightExistenceTracker regionHighlightExistenceTracker) {
        super(mapDimension, regionHighlightExistenceTracker);
        this.mapDimension = mapDimension;
        this.detectedRegions0 = new Long2ObjectOpenHashMap();
        this.completeDetectedRegions0 = new Long2ObjectOpenHashMap();
        this.completeDetectedRegionsLinked = new LinkedChain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegionDetection(RegionDetection regionDetection) {
        Long2ObjectOpenHashMap<RegionDetection> long2ObjectOpenHashMap = this.detectedRegions0;
        synchronized (long2ObjectOpenHashMap) {
            long packedPos = ChunkUtils.chunkPosToLong(regionDetection.getRegionX(), regionDetection.getRegionZ());
            this.detectedRegions0.put(packedPos, (Object)regionDetection);
            this.tryAddingToCompleteRegionDetection(regionDetection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionDetection getCompleteRegionDetection(int x, int z) {
        if (this.mapDimension.isUsingWorldSave()) {
            return this.mapDimension.getWorldSaveRegionDetection(x, z);
        }
        Long2ObjectOpenHashMap<RegionDetection> long2ObjectOpenHashMap = this.completeDetectedRegions0;
        synchronized (long2ObjectOpenHashMap) {
            long packedPos = ChunkUtils.chunkPosToLong(x, z);
            return (RegionDetection)this.completeDetectedRegions0.get(packedPos);
        }
    }

    private boolean completeRegionDetectionContains(RegionDetection regionDetection) {
        return this.getCompleteRegionDetection(regionDetection.getRegionX(), regionDetection.getRegionZ()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryAddingToCompleteRegionDetection(RegionDetection regionDetection) {
        if (!this.completeRegionDetectionContains(regionDetection)) {
            if (this.mapDimension.isUsingWorldSave()) {
                this.mapDimension.addWorldSaveRegionDetection(regionDetection);
            } else {
                Long2ObjectOpenHashMap<RegionDetection> long2ObjectOpenHashMap = this.completeDetectedRegions0;
                synchronized (long2ObjectOpenHashMap) {
                    long packedPos = ChunkUtils.chunkPosToLong(regionDetection.getRegionX(), regionDetection.getRegionZ());
                    this.completeDetectedRegions0.put(packedPos, (Object)regionDetection);
                    this.completeDetectedRegionsLinked.add((ILinkedChainNode)regionDetection);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionDetection getRegionDetection(int x, int z) {
        RegionDetection result = null;
        Long2ObjectOpenHashMap<RegionDetection> long2ObjectOpenHashMap = this.detectedRegions0;
        synchronized (long2ObjectOpenHashMap) {
            long packedPos = ChunkUtils.chunkPosToLong(x, z);
            result = (RegionDetection)this.detectedRegions0.get(packedPos);
        }
        if (result == null) {
            RegionDetection worldSaveDetection = this.mapDimension.getWorldSaveRegionDetection(x, z);
            if (worldSaveDetection != null) {
                result = new RegionDetection(worldSaveDetection.getWorldId(), worldSaveDetection.getDimId(), worldSaveDetection.getMwId(), worldSaveDetection.getRegionX(), worldSaveDetection.getRegionZ(), worldSaveDetection.getRegionFile(), worldSaveDetection.getInitialVersion(), worldSaveDetection.isHasHadTerrain());
                this.addRegionDetection(result);
                return result;
            }
        } else if (result.isRemoved()) {
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegionDetection(int x, int z) {
        if (this.mapDimension.getWorldSaveRegionDetection(x, z) != null) {
            RegionDetection regionDetection = this.getRegionDetection(x, z);
            if (regionDetection != null) {
                regionDetection.setRemoved(true);
            }
        } else {
            Long2ObjectOpenHashMap<RegionDetection> long2ObjectOpenHashMap = this.detectedRegions0;
            synchronized (long2ObjectOpenHashMap) {
                long packedPos = ChunkUtils.chunkPosToLong(x, z);
                this.detectedRegions0.remove(packedPos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<Integer, Hashtable<Integer, RegionDetection>> getDetectedRegions() {
        Hashtable<Integer, Hashtable<Integer, RegionDetection>> resultTable = new Hashtable<Integer, Hashtable<Integer, RegionDetection>>();
        Long2ObjectOpenHashMap<RegionDetection> long2ObjectOpenHashMap = this.detectedRegions0;
        synchronized (long2ObjectOpenHashMap) {
            for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.detectedRegions0)) {
                long packedPos = entry.getLongKey();
                int x = ChunkUtils.longToChunkX(packedPos);
                int z = ChunkUtils.longToChunkZ(packedPos);
                RegionDetection regionDetection = (RegionDetection)entry.getValue();
                Hashtable<Integer, Object> column = resultTable.get(x);
                if (column == null) {
                    column = new Hashtable();
                    resultTable.put(x, column);
                }
                column.put(z, regionDetection);
            }
        }
        return resultTable;
    }

    public Iterable<RegionDetection> getLinkedCompleteWorldSaveDetectedRegions() {
        return this.mapDimension.isUsingWorldSave() ? this.mapDimension.getLinkedWorldSaveDetectedRegions() : this.completeDetectedRegionsLinked;
    }

    public void preDetection() {
        this.detectedRegions0.clear();
        this.completeDetectedRegions0.clear();
        this.completeDetectedRegionsLinked.reset();
    }
}

