/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.line;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import xaero.lib.client.graphics.shader.FramebufferLinesShaderHelper;
import xaero.map.gui.GuiMap;
import xaeroplus.Globals;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.DrawFeature;
import xaeroplus.module.impl.TickTaskExecutor;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.GuiMapHelper;

public abstract class AbstractLineDrawFeature<T>
implements DrawFeature {
    public final AsyncLoadingCache<Long, T> lineRenderCache;

    protected AbstractLineDrawFeature(int refreshIntervalMs) {
        this.lineRenderCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).refreshAfterWrite(refreshIntervalMs, TimeUnit.MILLISECONDS).executor(TickTaskExecutor.INSTANCE).buildAsync(k -> this.loadLinesInWindow());
    }

    @Override
    public void invalidateCache() {
        this.lineRenderCache.synchronous().invalidateAll();
    }

    public abstract float lineWidth();

    public T loadLinesInWindow() {
        int windowSize;
        int windowZ;
        int windowX;
        Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
        if (guiMapOptional.isPresent()) {
            GuiMap guiMap = guiMapOptional.get();
            windowX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
            windowZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
            windowSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
        } else {
            windowX = ChunkUtils.getPlayerRegionX();
            windowZ = ChunkUtils.getPlayerRegionZ();
            windowSize = Math.max(3, Globals.minimapScaleMultiplier);
        }
        return this.preProcessLines(this.provideLinesInWindow(windowX, windowZ, windowSize, Globals.getCurrentDimensionId()), windowX, windowZ, windowSize);
    }

    public abstract T provideLinesInWindow(int var1, int var2, int var3, class_5321<class_1937> var4);

    public abstract T preProcessLines(T var1, int var2, int var3, int var4);

    public abstract T emptyLines();

    public T getLines() {
        return this.lineRenderCache.get(0L).getNow(this.emptyLines());
    }

    public void preRender(DrawContext ctx) {
        class_310 mc = class_310.method_1551();
        if (ctx.worldmap()) {
            FramebufferLinesShaderHelper.setFrameSize((float)mc.method_22683().method_4489(), (float)mc.method_22683().method_4506());
        }
    }

    @Override
    public void close() {
        this.lineRenderCache.synchronous().invalidateAll();
    }
}

