/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ThreadLocalRandom;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xaero.lib.common.util.IOUtils;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.settings.Settings;

@Mixin(value={IOUtils.class}, remap=false)
public class MixinIOUtils {
    @WrapOperation(method={"quickFileBackupMove(Ljava/nio/file/Path;)Ljava/nio/file/Path;"}, at={@At(value="INVOKE", target="Ljava/nio/file/Path;resolveSibling(Ljava/lang/String;)Ljava/nio/file/Path;", ordinal=0)})
    private static Path randomizeBackupPath(Path instance, String pathArg, Operation<Path> original) {
        return (Path)original.call(new Object[]{instance, pathArg + "-xp-" + ThreadLocalRandom.current().nextInt(0, 2000000000)});
    }

    @Inject(method={"safeMoveAndReplace(Ljava/nio/file/Path;Ljava/nio/file/Path;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void atomicMoveAndReplace(Path from, Path to, boolean backupFrom, CallbackInfo ci) throws IOException {
        if (!Globals.atomicMoveAvailable || !Settings.REGISTRY.atomicMoveAndReplace.get()) {
            return;
        }
        try {
            Files.move(from, to, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            ci.cancel();
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.debug("Failed atomic move, falling back to normal xaero logic", (Throwable)e);
            Settings.REGISTRY.atomicMoveAndReplace.setValue(false);
        }
    }
}

