/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.map.file.RegionDetection;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;
import xaeroplus.settings.Settings;

@Mixin(value={MapDimension.class}, remap=false)
public class MixinMapDimension {
    @Shadow
    @Final
    private MapWorld mapWorld;

    @Inject(method={"getWorldSaveRegionDetection(II)Lxaero/map/file/RegionDetection;"}, at={@At(value="HEAD")}, cancellable=true)
    public void fastGetWorldSaveRegionDetection(int x, int z, CallbackInfoReturnable<RegionDetection> cir) {
        if (Settings.REGISTRY.optimizeRegionDetectionLookups.get()) {
            MapDimension currentDimension;
            if (this.mapWorld.isMultiplayer()) {
                cir.setReturnValue(null);
            }
            if ((currentDimension = this.mapWorld.getCurrentDimension()) != null && !currentDimension.isUsingWorldSave()) {
                cir.setReturnValue(null);
            }
        }
    }
}

