/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.recipe.vanilla.IJeiShapedRecipeBuilder;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.library.plugins.vanilla.crafting.JeiShapedRecipe;
import net.minecraft.class_10302;
import net.minecraft.class_1856;
import net.minecraft.class_3955;
import net.minecraft.class_7710;
import net.minecraft.class_8957;

public class JeiShapedRecipeBuilder
implements IJeiShapedRecipeBuilder {
    private final class_7710 category;
    private final class_10302 results;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, class_1856> key = Maps.newLinkedHashMap();
    private final Map<Character, class_10302> displayKey = Maps.newLinkedHashMap();
    private String group = "";

    public JeiShapedRecipeBuilder(class_7710 category, class_10302 results) {
        this.category = category;
        this.results = results;
    }

    @Override
    public JeiShapedRecipeBuilder define(Character character, class_1856 ingredient) {
        if (this.key.containsKey(character)) {
            throw new IllegalArgumentException("Symbol '" + character + "' is already defined!");
        }
        if (character.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(character, ingredient);
        this.displayKey.put(character, ingredient.method_64673());
        return this;
    }

    @Override
    public IJeiShapedRecipeBuilder define(Character character, class_1856 ingredient, class_10302 display) {
        if (this.key.containsKey(character)) {
            throw new IllegalArgumentException("Symbol '" + character + "' is already defined!");
        }
        if (character.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(character, ingredient);
        this.displayKey.put(character, display);
        return this;
    }

    @Override
    public JeiShapedRecipeBuilder pattern(String patternRow) {
        if (!this.rows.isEmpty() && patternRow.length() != this.rows.getFirst().length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(patternRow);
        return this;
    }

    @Override
    public JeiShapedRecipeBuilder group(String $$0) {
        this.group = $$0;
        return this;
    }

    @Override
    public class_3955 build() {
        class_8957 pattern = class_8957.method_55085(this.key, this.rows);
        List displays = (List)JeiShapedRecipeBuilder.unpack(this.displayKey, this.rows).getOrThrow();
        return new JeiShapedRecipe(this.group, this.category, pattern, displays, this.results);
    }

    private static DataResult<List<class_10302>> unpack(Map<Character, class_10302> key, List<String> pattern) {
        IPlatformRecipeHelper recipeHelper = Services.PLATFORM.getRecipeHelper();
        String[] shrunkPattern = recipeHelper.shrinkShapedRecipePattern(pattern);
        int i = shrunkPattern[0].length();
        int j = shrunkPattern.length;
        ArrayList<class_10302.class_10305> list = new ArrayList<class_10302.class_10305>(i * j);
        CharArraySet charset = new CharArraySet(key.keySet());
        for (String s : shrunkPattern) {
            for (int k = 0; k < s.length(); ++k) {
                class_10302.class_10305 slotDisplay;
                char c = s.charAt(k);
                if (c == ' ') {
                    slotDisplay = class_10302.class_10305.field_54681;
                } else {
                    slotDisplay = key.get(Character.valueOf(c));
                    if (slotDisplay == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + c + "' but it's not defined in the key");
                    }
                }
                charset.remove(c);
                list.add(slotDisplay);
            }
        }
        if (!charset.isEmpty()) {
            return DataResult.error(() -> JeiShapedRecipeBuilder.lambda$unpack$1((CharSet)charset));
        }
        return DataResult.success(list);
    }

    private static /* synthetic */ String lambda$unpack$1(CharSet charset) {
        return "Key defines symbols that aren't used in pattern: " + String.valueOf(charset);
    }
}

