/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.grindstone;

import java.util.List;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiGrindstoneRecipe;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jspecify.annotations.Nullable;

public class GrindstoneRecipeCategory
extends AbstractRecipeCategory<IJeiGrindstoneRecipe> {
    private static final String topSlotName = "topSlot";
    private static final String bottomSlotName = "bottomSlot";

    public GrindstoneRecipeCategory(IGuiHelper guiHelper) {
        super(RecipeTypes.GRINDSTONE, (class_2561)class_2561.method_43471((String)"gui.jei.category.grindstone"), guiHelper.createDrawableItemLike((class_1935)class_2246.field_16337), 73, 52);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, IJeiGrindstoneRecipe recipe, IFocusGroup focuses) {
        List<class_1799> topInputs = recipe.getTopInputs();
        List<class_1799> bottomInputs = recipe.getBottomInputs();
        List<class_1799> outputs = recipe.getOutputs();
        IRecipeSlotBuilder topInputSlot = ((IRecipeSlotBuilder)builder.addInputSlot(1, 1).addItemStacks(topInputs)).setStandardSlotBackground().setSlotName(topSlotName);
        IRecipeSlotBuilder bottomInputSlot = ((IRecipeSlotBuilder)builder.addInputSlot(1, 24).addItemStacks(bottomInputs)).setStandardSlotBackground().setSlotName(bottomSlotName);
        int outputSlotXPosition = 52;
        int outputSlotYPosition = 13;
        IRecipeSlotBuilder outputSlot = recipe.isOutputRenderOnly() ? builder.addSlot(RecipeIngredientRole.RENDER_ONLY, outputSlotXPosition, outputSlotYPosition) : builder.addOutputSlot(outputSlotXPosition, outputSlotYPosition);
        outputSlot.setOutputSlotBackground().addItemStacks(outputs);
        if (topInputs.size() == bottomInputs.size()) {
            if (topInputs.size() == outputs.size()) {
                builder.createFocusLink(topInputSlot, bottomInputSlot, outputSlot);
            }
        } else if (topInputs.size() == outputs.size() && bottomInputs.size() == 1) {
            builder.createFocusLink(topInputSlot, outputSlot);
        } else if (bottomInputs.size() == outputs.size() && topInputs.size() == 1) {
            builder.createFocusLink(bottomInputSlot, outputSlot);
        }
    }

    @Override
    public void createRecipeExtras(IRecipeExtrasBuilder builder, IJeiGrindstoneRecipe recipe, IFocusGroup focuses) {
        builder.addRecipeArrow().setPosition(20, 12);
        int maxXpReward = recipe.getMaxXpReward();
        if (maxXpReward > 0) {
            int minXpReward = recipe.getMinXpReward();
            class_5250 text = class_2561.method_43469((String)"gui.jei.category.grindstone.experience", (Object[])new Object[]{minXpReward, maxXpReward});
            ((ITextWidget)builder.addText((class_5348)text, this.getWidth(), 10).setPosition(0, 43)).setColor(-8323296).setShadow(true).setTextAlignment(HorizontalAlignment.RIGHT);
        }
    }

    @Override
    public @Nullable class_2960 getIdentifier(IJeiGrindstoneRecipe recipe) {
        return recipe.getUid();
    }
}

