/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create;

import com.zurrtum.create.AllRecipeSets;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttributeType;
import com.zurrtum.create.content.logistics.item.filter.attribute.SingletonItemAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.attributes.AddedByAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.attributes.BookAuthorAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.attributes.BookCopyAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.attributes.ColorAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.attributes.EnchantAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.attributes.FluidContentsAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.attributes.InItemGroupAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.attributes.InTagAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.attributes.ItemNameAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.attributes.ShulkerFillLevelAttribute;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_10192;
import net.minecraft.class_10290;
import net.minecraft.class_1304;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3962;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import net.minecraft.class_9696;

public class AllItemAttributeTypes {
    public static final ItemAttributeType PLACEABLE = AllItemAttributeTypes.singleton("placeable", (class_1799 s) -> s.method_7909() instanceof class_1747);
    public static final ItemAttributeType CONSUMABLE = AllItemAttributeTypes.singleton("consumable", (class_1799 s) -> s.method_57826(class_9334.field_50075));
    public static final ItemAttributeType FLUID_CONTAINER = AllItemAttributeTypes.singleton("fluid_container", FluidHelper::hasFluidInventory);
    public static final ItemAttributeType ENCHANTED = AllItemAttributeTypes.singleton("enchanted", class_1799::method_7942);
    public static final ItemAttributeType MAX_ENCHANTED = AllItemAttributeTypes.singleton("max_enchanted", AllItemAttributeTypes::maxEnchanted);
    public static final ItemAttributeType RENAMED = AllItemAttributeTypes.singleton("renamed", (class_1799 s) -> s.method_57826(class_9334.field_49631));
    public static final ItemAttributeType DAMAGED = AllItemAttributeTypes.singleton("damaged", class_1799::method_7986);
    public static final ItemAttributeType BADLY_DAMAGED = AllItemAttributeTypes.singleton("badly_damaged", (class_1799 s) -> s.method_7986() && (float)s.method_7919() / (float)s.method_7936() > 0.75f);
    public static final ItemAttributeType NOT_STACKABLE = AllItemAttributeTypes.singleton("not_stackable", ((Predicate<class_1799>)class_1799::method_7946).negate());
    public static final ItemAttributeType EQUIPABLE = AllItemAttributeTypes.singleton("equipable", (class_1799 s) -> {
        class_10192 equipable = (class_10192)s.method_58694(class_9334.field_54196);
        class_1304.class_1305 type = equipable != null ? equipable.comp_3174().method_5925() : class_1304.field_6173.method_5925();
        return type != class_1304.class_1305.field_6177;
    });
    public static final ItemAttributeType FURNACE_FUEL = AllItemAttributeTypes.singleton("furnace_fuel", (class_1799 s, class_1937 w) -> w.method_61269().method_61752(s));
    public static final ItemAttributeType WASHABLE = AllItemAttributeTypes.singleton("washable", AllFanProcessingTypes.SPLASHING::canProcess);
    public static final ItemAttributeType HAUNTABLE = AllItemAttributeTypes.singleton("hauntable", AllFanProcessingTypes.HAUNTING::canProcess);
    public static final ItemAttributeType CRUSHABLE = AllItemAttributeTypes.singleton("crushable", (class_1799 s, class_1937 w) -> AllItemAttributeTypes.testRecipe(s, w, AllRecipeSets.CRUSHING) || AllItemAttributeTypes.testRecipe(s, w, AllRecipeSets.MILLING));
    public static final ItemAttributeType SMELTABLE = AllItemAttributeTypes.singleton("smeltable", (class_1799 s, class_1937 w) -> AllItemAttributeTypes.testRecipe(s, w, (class_5321<class_10290>)class_10290.field_54650));
    public static final ItemAttributeType SMOKABLE = AllItemAttributeTypes.singleton("smokable", (class_1799 s, class_1937 w) -> AllItemAttributeTypes.testRecipe(s, w, (class_5321<class_10290>)class_10290.field_54652));
    public static final ItemAttributeType BLASTABLE = AllItemAttributeTypes.singleton("blastable", (class_1799 s, class_1937 w) -> AllItemAttributeTypes.testRecipe(s, w, (class_5321<class_10290>)class_10290.field_54651));
    public static final ItemAttributeType COMPOSTABLE = AllItemAttributeTypes.singleton("compostable", (class_1799 s) -> class_3962.field_17566.containsKey((Object)s.method_7909()));
    public static final ItemAttributeType IN_TAG = AllItemAttributeTypes.register("in_tag", new InTagAttribute.Type());
    public static final ItemAttributeType IN_ITEM_GROUP = AllItemAttributeTypes.register("in_item_group", new InItemGroupAttribute.Type());
    public static final ItemAttributeType ADDED_BY = AllItemAttributeTypes.register("added_by", new AddedByAttribute.Type());
    public static final ItemAttributeType HAS_ENCHANT = AllItemAttributeTypes.register("has_enchant", new EnchantAttribute.Type());
    public static final ItemAttributeType SHULKER_FILL_LEVEL = AllItemAttributeTypes.register("shulker_fill_level", new ShulkerFillLevelAttribute.Type());
    public static final ItemAttributeType HAS_COLOR = AllItemAttributeTypes.register("has_color", new ColorAttribute.Type());
    public static final ItemAttributeType HAS_FLUID = AllItemAttributeTypes.register("has_fluid", new FluidContentsAttribute.Type());
    public static final ItemAttributeType HAS_NAME = AllItemAttributeTypes.register("has_name", new ItemNameAttribute.Type());
    public static final ItemAttributeType BOOK_AUTHOR = AllItemAttributeTypes.register("book_author", new BookAuthorAttribute.Type());
    public static final ItemAttributeType BOOK_COPY = AllItemAttributeTypes.register("book_copy", new BookCopyAttribute.Type());

    private static <T extends class_1860<class_9696>> boolean testRecipe(class_1799 s, class_1937 w, class_5321<class_10290> key) {
        return w.method_8433().method_64678(key).method_64701(s);
    }

    private static boolean maxEnchanted(class_1799 s) {
        for (Object2IntMap.Entry entry : s.method_58657().method_57539()) {
            if (((class_1887)((class_6880)entry.getKey()).comp_349()).method_8183() > entry.getIntValue()) continue;
            return true;
        }
        return false;
    }

    private static ItemAttributeType singleton(String id, Predicate<class_1799> predicate) {
        return AllItemAttributeTypes.register(id, new SingletonItemAttribute.Type(type -> new SingletonItemAttribute((SingletonItemAttribute.Type)type, (stack, level) -> predicate.test((class_1799)stack), id)));
    }

    private static ItemAttributeType singleton(String id, BiPredicate<class_1799, class_1937> predicate) {
        return AllItemAttributeTypes.register(id, new SingletonItemAttribute.Type(type -> new SingletonItemAttribute((SingletonItemAttribute.Type)type, predicate, id)));
    }

    private static ItemAttributeType register(String id, ItemAttributeType type) {
        return (ItemAttributeType)class_2378.method_10230(CreateRegistries.ITEM_ATTRIBUTE_TYPE, (class_2960)class_2960.method_60655((String)"create", (String)id), (Object)type);
    }

    public static void register() {
    }
}

