/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.api.contraption.storage.item;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorageType;
import com.zurrtum.create.api.contraption.storage.item.menu.MountedStorageMenus;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_11565;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3499;
import net.minecraft.class_3908;
import net.minecraft.class_5250;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public abstract class MountedItemStorage
implements ItemInventory {
    public static final Codec<MountedItemStorage> CODEC = MountedItemStorageType.CODEC.dispatch(storage -> storage.type, type -> type.codec);
    public static final class_9139<class_9129, MountedItemStorage> STREAM_CODEC = class_9139.method_56438((b, t) -> t.method_29172((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)t.method_56349()), CODEC, b), b -> (MountedItemStorage)b.method_52954((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)b.method_56349()), CODEC));
    public final MountedItemStorageType<? extends MountedItemStorage> type;

    protected MountedItemStorage(MountedItemStorageType<?> type) {
        this.type = Objects.requireNonNull(type);
    }

    public abstract void unmount(class_1937 var1, class_2680 var2, class_2338 var3, @Nullable class_2586 var4);

    public boolean handleInteraction(class_3222 player, Contraption contraption, class_3499.class_3501 info) {
        Consumer<class_11565> onClose;
        class_1263 handler;
        class_3218 level = player.method_51469();
        class_2338 localPos = info.comp_1341();
        class_243 localPosVec = class_243.method_24953((class_2382)localPos);
        Predicate<class_1657> stillValid = p -> {
            class_243 currentPos = contraption.entity.toGlobalVector(localPosVec, 0.0f);
            return this.isMenuValid(player, contraption, currentPos);
        };
        class_2561 menuName = this.getMenuName(info, contraption);
        OptionalInt id = player.method_17355(this.createMenuProvider(menuName, handler = this.getHandlerForMenu(info, contraption), stillValid, onClose = p -> {
            class_243 newPos = contraption.entity.toGlobalVector(localPosVec, 0.0f);
            this.playClosingSound(level, newPos);
        }));
        if (id.isPresent()) {
            class_243 globalPos = contraption.entity.toGlobalVector(localPosVec, 0.0f);
            this.playOpeningSound(level, globalPos);
            return true;
        }
        return false;
    }

    protected class_1263 getHandlerForMenu(class_3499.class_3501 info, Contraption contraption) {
        return this;
    }

    protected boolean isMenuValid(class_3222 player, Contraption contraption, class_243 pos) {
        return contraption.entity.method_5805() && player.method_5707(pos) < 64.0;
    }

    protected class_2561 getMenuName(class_3499.class_3501 info, Contraption contraption) {
        class_5250 blockName = info.comp_1342().method_26204().method_9518();
        return class_2561.method_43469((String)"create.contraptions.moving_container", (Object[])new Object[]{blockName});
    }

    @Nullable
    protected class_3908 createMenuProvider(class_2561 name, class_1263 handler, Predicate<class_1657> stillValid, Consumer<class_11565> onClose) {
        return MountedStorageMenus.createGeneric(name, handler, stillValid, onClose);
    }

    protected void playOpeningSound(class_3218 level, class_243 pos) {
        level.method_8396(null, class_2338.method_49638((class_2374)pos), class_3417.field_17604, class_3419.field_15245, 0.75f, 1.0f);
    }

    protected void playClosingSound(class_3218 level, class_243 pos) {
    }
}

