/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.levelWrappers;

import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.components.ComponentProcessors;
import com.zurrtum.create.catnip.levelWrappers.SchematicChunkSource;
import com.zurrtum.create.catnip.levelWrappers.SchematicLevelAccessor;
import com.zurrtum.create.catnip.levelWrappers.WrappedLevel;
import com.zurrtum.create.catnip.math.BBHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_12131;
import net.minecraft.class_12206;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2363;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4076;
import net.minecraft.class_5425;
import net.minecraft.class_6754;
import net.minecraft.class_6756;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class SchematicLevel
extends WrappedLevel
implements class_5425,
SchematicLevelAccessor {
    protected Map<class_2338, class_2680> blocks;
    protected Map<class_2338, class_2586> blockEntities;
    protected List<class_2586> renderedBlockEntities;
    protected List<class_1297> entities;
    protected class_3341 bounds;
    public class_2338 anchor;
    public boolean renderMode;

    public SchematicLevel(class_1937 original) {
        this(class_2338.field_10980, original);
    }

    public SchematicLevel(class_2338 anchor, class_1937 original) {
        super(original);
        this.setChunkSource(new SchematicChunkSource(this));
        this.blocks = new HashMap<class_2338, class_2680>();
        this.blockEntities = new HashMap<class_2338, class_2586>();
        this.bounds = new class_3341(class_2338.field_10980);
        this.anchor = anchor;
        this.entities = new ArrayList<class_1297>();
        this.renderedBlockEntities = new ArrayList<class_2586>();
    }

    public class_1266 method_8404(class_2338 pos) {
        long localTime = 0L;
        float moonBrightness = 0.0f;
        class_2791 chunk = this.level.method_8402(class_4076.method_18675((int)pos.method_10263()), class_4076.method_18675((int)pos.method_10260()), class_2806.field_12803, false);
        if (chunk != null) {
            localTime = chunk.method_12033();
            class_12131 moonPhase = (class_12131)this.level.method_75728().method_75697(class_12206.field_64343, pos);
            moonBrightness = class_2874.field_24752[moonPhase.method_75261()];
        }
        return new class_1266(this.level.method_8407(), this.level.method_8532(), localTime, moonBrightness);
    }

    @Override
    public Set<class_2338> getAllPositions() {
        return this.blocks.keySet();
    }

    @Override
    public boolean method_8649(class_1297 entityIn) {
        if (entityIn instanceof class_1533) {
            class_1533 itemFrame = (class_1533)entityIn;
            itemFrame.method_6935(ComponentProcessors.withUnsafeComponentsDiscarded(itemFrame.method_6940()));
        }
        if (entityIn instanceof class_1531) {
            class_1531 armorStand = (class_1531)entityIn;
            for (class_1304 equipmentSlot : class_1304.values()) {
                armorStand.method_5673(equipmentSlot, ComponentProcessors.withUnsafeComponentsDiscarded(armorStand.method_6118(equipmentSlot)));
            }
        }
        return this.entities.add(entityIn);
    }

    @Override
    public List<class_1297> getEntityList() {
        return this.entities;
    }

    @Override
    public class_2586 method_8321(class_2338 pos) {
        if (this.method_31606(pos)) {
            return null;
        }
        if (this.blockEntities.containsKey(pos)) {
            return this.blockEntities.get(pos);
        }
        if (!this.blocks.containsKey(pos.method_10059((class_2382)this.anchor))) {
            return null;
        }
        class_2680 blockState = this.method_8320(pos);
        if (blockState.method_31709()) {
            try {
                class_2586 blockEntity = ((class_2343)blockState.method_26204()).method_10123(pos, blockState);
                if (blockEntity != null) {
                    this.onBEadded(blockEntity, pos);
                    this.blockEntities.put(pos, blockEntity);
                    this.renderedBlockEntities.add(blockEntity);
                }
                return blockEntity;
            }
            catch (Exception e) {
                Create.LOGGER.debug("Could not create BlockEntity of block " + String.valueOf(blockState), (Throwable)e);
            }
        }
        return null;
    }

    protected void onBEadded(class_2586 blockEntity, class_2338 pos) {
        blockEntity.method_31662((class_1937)this);
    }

    @Override
    public class_2680 method_8320(class_2338 globalPos) {
        class_2338 pos = globalPos.method_10059((class_2382)this.anchor);
        if (pos.method_10264() - this.bounds.method_35416() == -1 && !this.renderMode) {
            return class_2246.field_10566.method_9564();
        }
        if (this.getBounds().method_14662((class_2382)pos) && this.blocks.containsKey(pos)) {
            return this.processBlockStateForPrinting(this.blocks.get(pos));
        }
        return class_2246.field_10124.method_9564();
    }

    @Override
    public Map<class_2338, class_2680> getBlockMap() {
        return this.blocks;
    }

    public class_3610 method_8316(class_2338 pos) {
        return this.method_8320(pos).method_26227();
    }

    public class_6880<class_1959> method_23753(class_2338 pos) {
        return this.level.method_30349().method_30530(class_7924.field_41236).method_46747(class_1972.field_9451);
    }

    public int method_8314(class_1944 lightLayer, class_2338 pos) {
        return 15;
    }

    @Override
    public float method_24852(class_2350 face, boolean hasShade) {
        return 1.0f;
    }

    @Override
    public class_6756<class_2248> method_8397() {
        return class_6754.method_39362();
    }

    @Override
    public class_6756<class_3611> method_8405() {
        return class_6754.method_39362();
    }

    public List<class_1297> method_8333(class_1297 arg0, class_238 arg1, Predicate<? super class_1297> arg2) {
        return Collections.emptyList();
    }

    public <T extends class_1297> List<T> method_8390(Class<T> arg0, class_238 arg1, Predicate<? super T> arg2) {
        return Collections.emptyList();
    }

    @Override
    public List<? extends class_1657> method_18456() {
        return Collections.emptyList();
    }

    public int method_8594() {
        return 0;
    }

    @Override
    public boolean method_16358(class_2338 pos, Predicate<class_2680> predicate) {
        return predicate.test(this.method_8320(pos));
    }

    public boolean method_22352(class_2338 arg0, boolean arg1) {
        return this.method_8652(arg0, class_2246.field_10124.method_9564(), 3);
    }

    public boolean method_8650(class_2338 arg0, boolean arg1) {
        return this.method_8652(arg0, class_2246.field_10124.method_9564(), 3);
    }

    @Override
    public boolean method_8652(class_2338 pos, class_2680 arg1, int arg2) {
        class_2586 blockEntity;
        pos = pos.method_10062().method_10059((class_2382)this.anchor);
        this.bounds = BBHelper.encapsulate(this.bounds, pos);
        this.blocks.put(pos, arg1);
        if (this.blockEntities.containsKey(pos) && !(blockEntity = this.blockEntities.get(pos)).method_11017().method_20526(arg1)) {
            this.blockEntities.remove(pos);
            this.renderedBlockEntities.remove(blockEntity);
        }
        if ((blockEntity = this.method_8321(pos)) != null) {
            this.blockEntities.put(pos, blockEntity);
        }
        return true;
    }

    @Override
    public void method_8413(class_2338 pos, class_2680 oldState, class_2680 newState, int flags) {
    }

    @Override
    public class_3341 getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(class_3341 bounds) {
        this.bounds = bounds;
    }

    @Override
    public Iterable<class_2586> getBlockEntities() {
        return this.blockEntities.values();
    }

    @Override
    public Iterable<class_2586> getRenderedBlockEntities() {
        return this.renderedBlockEntities;
    }

    protected class_2680 processBlockStateForPrinting(class_2680 state) {
        if (state.method_26204() instanceof class_2363 && state.method_28498((class_2769)class_2741.field_12548)) {
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public class_3218 method_8410() {
        class_1937 class_19372 = this.level;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            return serverWorld;
        }
        throw new IllegalStateException("Cannot use IServerWorld#getWorld in a client environment");
    }
}

