/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.eiv.view;

import com.zurrtum.create.client.compat.eiv.CreateView;
import com.zurrtum.create.client.compat.eiv.EivClientPlugin;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.CrafterRenderState;
import com.zurrtum.create.compat.eiv.display.MechanicalCraftingDisplay;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11256;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class MechanicalCraftingView
extends CreateView {
    private final SlotContent result;
    private final List<SlotContent> ingredients;
    private final int width;
    private final int height;
    private final IntSet empty;

    public MechanicalCraftingView(MechanicalCraftingDisplay display) {
        this.result = SlotContent.of((class_1799)display.result);
        this.width = display.width;
        this.height = display.height;
        this.empty = new IntOpenHashSet(display.empty);
        this.ingredients = display.ingredients.stream().map(SlotContent::of).toList();
        int total = this.width * this.height;
        for (int i = this.ingredients.size() + this.empty.size(); i < total; ++i) {
            this.empty.add(i);
        }
    }

    public IEivRecipeViewType getViewType() {
        return EivClientPlugin.MECHANICAL_CRAFTING;
    }

    public List<SlotContent> getIngredients() {
        return this.ingredients;
    }

    public List<SlotContent> getResults() {
        return List.of(this.result);
    }

    @Override
    protected int placeViewSlots(RecipeViewMenu.SlotDefinition slotDefinition) {
        int left = 7;
        if (this.width < 5) {
            left += 19 * (5 - this.width) / 2;
        }
        int top = 1;
        if (this.height < 5) {
            top += 19 * (5 - this.height) / 2;
        }
        int i = 0;
        for (int h = 0; h < this.height; ++h) {
            for (int w = 0; w < this.width; ++w) {
                if (this.empty.contains(h * this.width + w)) continue;
                slotDefinition.addItemSlot(i++, left + 16 * w + w * 3, top + 16 * h + h * 3);
            }
        }
        slotDefinition.addItemSlot(i++, 133, 74);
        return i;
    }

    @Override
    protected int bindViewSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        int i;
        int size = this.ingredients.size();
        for (i = 0; i < size; ++i) {
            slotFillContext.bindOptionalSlot(i, this.ingredients.get(i), SLOT);
        }
        slotFillContext.bindOptionalSlot(i++, this.result, SLOT);
        return i;
    }

    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition position, class_332 context, int mouseX, int mouseY, float partialTicks) {
        AllGuiTextures.JEI_DOWN_ARROW.render(context, 128, 53);
        AllGuiTextures.JEI_SHADOW.render(context, 113, 32);
        context.field_59826.method_70922((class_11256)new CrafterRenderState(new Matrix3x2f((Matrix3x2fc)context.method_51448()), 124, 12));
        String size = String.valueOf(this.ingredients.size());
        context.method_51433(class_310.method_1551().field_1772, size, 142, 33, -1, true);
    }
}

