/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.actors.roller;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.actors.roller.RollerActorVisual;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_12249;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class RollerMovementRenderBehaviour
implements MovementRenderBehaviour {
    @Override
    @Nullable
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new RollerActorVisual(visualizationContext, simulationWorld, movementContext);
    }

    @Override
    public MovementRenderState getRenderState(class_243 camera, class_327 textRenderer, MovementContext context, VirtualRenderWorld renderWorld, Matrix4f worldMatrix4f) {
        float speed;
        if (VisualizationManager.supportsVisualization((class_1936)context.world)) {
            return null;
        }
        RollerMovementRenderState state = new RollerMovementRenderState(context.localPos);
        state.layer = class_12249.method_75972();
        class_2680 blockState = context.state;
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)class_2741.field_12481);
        state.wheel = CachedBuffers.partial(AllPartialModels.ROLLER_WHEEL, blockState);
        float f = speed = !VecHelper.isVecPointingTowards(context.relativeMotion, facing.method_10153()) ? context.getAnimationSpeed() : -context.getAnimationSpeed();
        if (context.contraption.stalled) {
            speed = 0.0f;
        }
        state.offset = class_243.method_24954((class_2382)facing.method_62675()).method_1021(1.0625).method_1031(0.0, -0.25, 0.0);
        float angle = AngleHelper.horizontalAngle(facing);
        state.wheelAngle = AngleHelper.rad(angle);
        float time = AnimationTickHolder.getRenderTime((class_1936)context.world) / 20.0f;
        state.rotate = AngleHelper.rad(time * speed % 360.0f);
        state.light = class_761.method_23794((class_1920)renderWorld, (class_2338)context.localPos);
        state.world = context.world;
        state.worldMatrix4f = worldMatrix4f;
        state.yRot = 1.5707964f;
        state.frame = CachedBuffers.partial(AllPartialModels.ROLLER_FRAME, blockState);
        state.frameAngle = AngleHelper.rad(angle + 180.0f);
        return state;
    }

    @Environment(value=EnvType.CLIENT)
    public static class RollerMovementRenderState
    extends MovementRenderState
    implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer wheel;
        public class_243 offset;
        public float wheelAngle;
        public float rotate;
        public int light;
        public class_1937 world;
        public Matrix4f worldMatrix4f;
        public float yRot;
        public SuperByteBuffer frame;
        public float frameAngle;

        public RollerMovementRenderState(class_2338 pos) {
            super(pos);
        }

        @Override
        public void render(class_4587 matrices, class_11659 queue) {
            queue.method_73483(matrices, this.layer, (class_11659.class_11660)this);
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.wheel.translate(this.offset)).rotateCentered(this.wheelAngle, class_2350.field_11036)).rotate(this.rotate, class_2350.field_11039)).translate(0.0, -0.5, 0.5)).rotateY(this.yRot)).light(this.light).useLevelLight((class_1920)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)this.frame.rotateCentered(this.frameAngle, class_2350.field_11036)).light(this.light).useLevelLight((class_1920)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

