/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.chainConveyor;

import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.content.trains.track.TrackBlockOutline;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class ChainConveyorShape {
    @Nullable
    public abstract class_243 intersect(class_243 var1, class_243 var2);

    public abstract float getChainPosition(class_243 var1);

    protected abstract void drawOutline(class_2338 var1, class_4587 var2, class_4588 var3);

    public abstract class_243 getVec(class_2338 var1, float var2);

    @Environment(value=EnvType.CLIENT)
    public static class ChainConveyorBB
    extends ChainConveyorShape {
        class_243 lb;
        class_243 rb;
        final double radius = 0.875;
        class_238 bounds;

        public ChainConveyorBB(class_243 center) {
            this.lb = center.method_1031(0.0, 0.0, 0.0);
            this.rb = center.method_1031(0.0, 0.5, 0.0);
            this.bounds = new class_238(this.lb, this.rb).method_1009(1.0, 0.0, 1.0);
        }

        @Override
        public class_243 intersect(class_243 from, class_243 to) {
            return this.bounds.method_992(from, to).orElse(null);
        }

        @Override
        public void drawOutline(class_2338 anchor, class_4587 ms, class_4588 vb) {
            TrackBlockOutline.renderShape(AllShapes.CHAIN_CONVEYOR_INTERACTION, ms, vb, null);
        }

        @Override
        public float getChainPosition(class_243 intersection) {
            class_243 diff = this.bounds.method_1005().method_1020(intersection);
            float angle = (float)(57.2957763671875 * class_3532.method_15349((double)diff.field_1352, (double)diff.field_1350) + 360.0 + 180.0) % 360.0f;
            float rounded = (float)Math.round(angle / 45.0f) * 45.0f;
            return rounded;
        }

        @Override
        public class_243 getVec(class_2338 anchor, float position) {
            class_243 point = this.bounds.method_1005();
            point = point.method_1019(VecHelper.rotate(new class_243(0.0, 0.0, 0.875), position, class_2350.class_2351.field_11052));
            return point.method_1019(class_243.method_24954((class_2382)anchor)).method_1031(0.0, -0.125, 0.0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ChainConveyorOBB
    extends ChainConveyorShape {
        public class_2338 connection;
        double yaw;
        double pitch;
        class_238 bounds;
        class_243 pivot;
        final double radius = 0.175;
        class_265 voxelShape;
        class_243[] linePoints;

        public ChainConveyorOBB(class_2338 connection, class_243 start, class_243 end) {
            this.connection = connection;
            class_243 diff = end.method_1020(start);
            double d = diff.method_1033();
            double dxz = diff.method_18805(1.0, 0.0, 1.0).method_1033();
            this.yaw = 57.2957763671875 * class_3532.method_15349((double)diff.field_1352, (double)diff.field_1350);
            this.pitch = 57.2957763671875 * class_3532.method_15349((double)(-diff.field_1351), (double)dxz);
            this.bounds = new class_238(start, start).method_1012(0.0, 0.0, d).method_1009(0.175, 0.175, 0.0);
            this.pivot = start;
            this.voxelShape = class_259.method_1078((class_238)this.bounds);
        }

        @Override
        public class_243 intersect(class_243 from, class_243 to) {
            class_243 result = this.bounds.method_992(from = this.counterTransform(from), to = this.counterTransform(to)).orElse(null);
            if (result == null) {
                return null;
            }
            result = this.transform(result);
            return result;
        }

        private class_243 counterTransform(class_243 from) {
            from = from.method_1020(this.pivot);
            from = VecHelper.rotate(from, -this.yaw, class_2350.class_2351.field_11052);
            from = VecHelper.rotate(from, -this.pitch, class_2350.class_2351.field_11048);
            from = from.method_1019(this.pivot);
            return from;
        }

        private class_243 transform(class_243 result) {
            result = result.method_1020(this.pivot);
            result = VecHelper.rotate(result, this.pitch, class_2350.class_2351.field_11048);
            result = VecHelper.rotate(result, this.yaw, class_2350.class_2351.field_11052);
            result = result.method_1019(this.pivot);
            return result;
        }

        @Override
        public void drawOutline(class_2338 anchor, class_4587 ms, class_4588 vb) {
            ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(ms).translate(this.pivot)).rotateYDegrees((float)this.yaw)).rotateXDegrees((float)this.pitch)).translateBack(this.pivot);
            TrackBlockOutline.renderShape(this.voxelShape, ms, vb, null);
        }

        @Override
        public float getChainPosition(class_243 intersection) {
            int dots = (int)Math.round(class_243.method_24954((class_2382)this.connection).method_1033() - 3.0);
            double length = this.bounds.method_17941();
            double selection = Math.min(this.bounds.method_17941(), intersection.method_1022(this.pivot));
            double margin = length - (double)dots;
            selection = class_3532.method_15350((double)(selection - margin), (double)0.0, (double)(length - margin * 2.0));
            selection = Math.round(selection);
            return (float)(selection + margin + 0.025);
        }

        @Override
        public class_243 getVec(class_2338 anchor, float position) {
            float x = (float)this.bounds.method_1005().field_1352;
            float y = (float)this.bounds.method_1005().field_1351;
            class_243 from = new class_243((double)x, (double)y, this.bounds.field_1321);
            class_243 to = new class_243((double)x, (double)y, this.bounds.field_1324);
            class_243 point = from.method_35590(to, class_3532.method_15350((double)((double)position / from.method_1022(to)), (double)0.0, (double)1.0));
            point = this.transform(point);
            return point.method_1019(class_243.method_24954((class_2382)anchor));
        }
    }
}

