/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.gearbox;

import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.gearbox.GearboxBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class GearboxRenderer
implements class_827<GearboxBlockEntity, GearboxRenderState> {
    public GearboxRenderer(class_5614.class_5615 context) {
    }

    public GearboxRenderState createRenderState() {
        return new GearboxRenderState();
    }

    public void extractRenderState(GearboxBlockEntity be, GearboxRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        float offset;
        class_11954.method_74399((class_2586)be, (class_11954)state, (class_11683.class_11792)crumblingOverlay);
        state.layer = class_12249.method_75965();
        class_2350.class_2351 boxAxis = (class_2350.class_2351)state.field_62674.method_11654((class_2769)class_2741.field_12496);
        class_2338 pos = state.field_62673;
        float time = AnimationTickHolder.getRenderTime((class_1936)be.method_10997());
        float speed = be.getSpeed();
        class_2338 source = null;
        class_2350 sourceFacing = null;
        if (speed != 0.0f && be.source != null) {
            source = be.source.method_10059((class_2382)state.field_62673);
            sourceFacing = class_2350.method_10147((float)source.method_10263(), (float)source.method_10264(), (float)source.method_10260());
        }
        state.color = KineticBlockEntityRenderer.getColor(be);
        float angle = time * speed * 3.0f / 10.0f % 360.0f;
        if (boxAxis != class_2350.class_2351.field_11052) {
            offset = KineticBlockEntityRenderer.getRotationOffsetForPosition(be, pos, class_2350.class_2351.field_11052);
            state.down = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.field_62674, class_2350.field_11033);
            state.downAngle = GearboxRenderer.getAngle(angle, offset, class_2350.field_11033, source, sourceFacing);
            state.up = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.field_62674, class_2350.field_11036);
            state.upAngle = GearboxRenderer.getAngle(angle, offset, class_2350.field_11036, source, sourceFacing);
        }
        if (boxAxis != class_2350.class_2351.field_11051) {
            offset = KineticBlockEntityRenderer.getRotationOffsetForPosition(be, pos, class_2350.class_2351.field_11051);
            state.north = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.field_62674, class_2350.field_11043);
            state.northAngle = GearboxRenderer.getAngle(angle, offset, class_2350.field_11043, source, sourceFacing);
            state.south = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.field_62674, class_2350.field_11035);
            state.southAngle = GearboxRenderer.getAngle(angle, offset, class_2350.field_11035, source, sourceFacing);
        }
        if (boxAxis != class_2350.class_2351.field_11048) {
            offset = KineticBlockEntityRenderer.getRotationOffsetForPosition(be, pos, class_2350.class_2351.field_11048);
            state.west = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.field_62674, class_2350.field_11039);
            state.westAngle = GearboxRenderer.getAngle(angle, offset, class_2350.field_11039, source, sourceFacing);
            state.east = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.field_62674, class_2350.field_11034);
            state.eastAngle = GearboxRenderer.getAngle(angle, offset, class_2350.field_11034, source, sourceFacing);
        }
    }

    private static float getAngle(float angle, float offset, class_2350 direction, class_2338 source, class_2350 sourceFacing) {
        if (source != null) {
            if (sourceFacing.method_10166() == direction.method_10166()) {
                angle *= sourceFacing == direction ? 1.0f : -1.0f;
            } else if (sourceFacing.method_10171() == direction.method_10171()) {
                angle *= -1.0f;
            }
        }
        return (angle += offset) / 180.0f * (float)Math.PI;
    }

    public void submit(GearboxRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, (class_11659.class_11660)state);
    }

    @Environment(value=EnvType.CLIENT)
    public static class GearboxRenderState
    extends class_11954
    implements class_11659.class_11660 {
        public class_1921 layer;
        public Color color;
        public SuperByteBuffer down;
        public float downAngle;
        public SuperByteBuffer up;
        public float upAngle;
        public SuperByteBuffer north;
        public float northAngle;
        public SuperByteBuffer south;
        public float southAngle;
        public SuperByteBuffer west;
        public float westAngle;
        public SuperByteBuffer east;
        public float eastAngle;

        private void render(SuperByteBuffer model, float angle, class_2350 axis, class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            model.light(this.field_62676);
            model.rotateCentered(angle, axis);
            model.color(this.color);
            model.renderInto(matricesEntry, vertexConsumer);
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (this.down != null) {
                this.render(this.down, this.downAngle, class_2350.field_11036, matricesEntry, vertexConsumer);
                this.render(this.up, this.upAngle, class_2350.field_11036, matricesEntry, vertexConsumer);
            }
            if (this.north != null) {
                this.render(this.north, this.northAngle, class_2350.field_11035, matricesEntry, vertexConsumer);
                this.render(this.south, this.southAngle, class_2350.field_11035, matricesEntry, vertexConsumer);
            }
            if (this.west != null) {
                this.render(this.west, this.westAngle, class_2350.field_11034, matricesEntry, vertexConsumer);
                this.render(this.east, this.eastAngle, class_2350.field_11034, matricesEntry, vertexConsumer);
            }
        }
    }
}

