/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.compile;

import com.zurrtum.create.client.flywheel.api.instance.InstanceType;
import com.zurrtum.create.client.flywheel.backend.gl.shader.GlProgram;
import com.zurrtum.create.client.flywheel.backend.glsl.SourceComponent;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public record Pipeline(class_2960 vertexMain, class_2960 fragmentMain, InstanceAssembler assembler, String compilerMarker, Consumer<GlProgram> onLink) {
    public static Builder builder() {
        return new Builder();
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface InstanceAssembler {
        public SourceComponent assemble(InstanceType<?> var1);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Builder {
        @Nullable
        private class_2960 vertexMain;
        @Nullable
        private class_2960 fragmentMain;
        @Nullable
        private InstanceAssembler assembler;
        @Nullable
        private String compilerMarker;
        @Nullable
        private Consumer<GlProgram> onLink;

        public Builder vertexMain(class_2960 shader) {
            this.vertexMain = shader;
            return this;
        }

        public Builder fragmentMain(class_2960 shader) {
            this.fragmentMain = shader;
            return this;
        }

        public Builder assembler(InstanceAssembler assembler) {
            this.assembler = assembler;
            return this;
        }

        public Builder compilerMarker(String compilerMarker) {
            this.compilerMarker = compilerMarker;
            return this;
        }

        public Builder onLink(Consumer<GlProgram> onLink) {
            this.onLink = onLink;
            return this;
        }

        public Pipeline build() {
            Objects.requireNonNull(this.vertexMain);
            Objects.requireNonNull(this.fragmentMain);
            Objects.requireNonNull(this.assembler);
            Objects.requireNonNull(this.compilerMarker);
            Objects.requireNonNull(this.onLink);
            return new Pipeline(this.vertexMain, this.fragmentMain, this.assembler, this.compilerMarker, this.onLink);
        }
    }
}

