/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.glsl.generate;

import com.mojang.datafixers.util.Pair;
import com.zurrtum.create.client.flywheel.backend.glsl.generate.GlslBuilder;
import com.zurrtum.create.client.flywheel.lib.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class GlslUniformBlock
implements GlslBuilder.Declaration {
    private String qualifier;
    private String name;
    private final List<Pair<String, String>> members = new ArrayList<Pair<String, String>>();

    public GlslUniformBlock layout(String qualifier) {
        this.qualifier = qualifier;
        return this;
    }

    public GlslUniformBlock name(String name) {
        this.name = name;
        return this;
    }

    public GlslUniformBlock member(String typeName, String variableName) {
        this.members.add((Pair<String, String>)Pair.of((Object)typeName, (Object)variableName));
        return this;
    }

    @Override
    public String prettyPrint() {
        return "layout(%s) uniform %s {\n%s\n};".formatted(this.qualifier, this.name, StringUtil.indent(this.formatMembers(), 4));
    }

    private String formatMembers() {
        return this.members.stream().map(p -> (String)p.getFirst() + " " + (String)p.getSecond() + ";").collect(Collectors.joining("\n"));
    }
}

