/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.zurrtum.create.client.flywheel.lib.model.SimpleModel;
import com.zurrtum.create.client.flywheel.lib.model.baked.BlockMaterialFunction;
import com.zurrtum.create.client.flywheel.lib.model.baked.MeshEmitterManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.TransformingVertexConsumer;
import com.zurrtum.create.client.flywheel.lib.model.baked.VanillinMeshEmitter;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import com.zurrtum.create.client.model.LayerBakedModel;
import com.zurrtum.create.foundation.block.LightControlBlock;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10801;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_778;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
final class BakedModelBufferer {
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    private BakedModelBufferer() {
    }

    private static boolean isDark(class_1920 level, class_2338 pos, class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof LightControlBlock) {
            LightControlBlock block = (LightControlBlock)class_22482;
            return block.getLuminance((class_1922)level, pos) == 0;
        }
        return state.method_26213() == 0;
    }

    public static SimpleModel bufferModel(class_10801 model, class_2338 pos, class_1920 level, class_2680 state, @Nullable class_4587 poseStack, BlockMaterialFunction blockMaterialFunction) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        if (poseStack == null) {
            poseStack = objects.identityPoseStack;
        }
        MeshEmitterManager<VanillinMeshEmitter> emitters = objects.emitters;
        emitters.prepare(blockMaterialFunction);
        class_778 blockRenderer = class_310.method_1551().method_1541().method_3350();
        class_11515 renderType = LayerBakedModel.getBlockRenderLayer(model, (Supplier<class_11515>)((Supplier)() -> class_4696.method_23679((class_2680)state)));
        VanillinMeshEmitter emitter = emitters.getEmitter(renderType);
        emitter.prepareForModelLayer(class_310.method_1588() && model.comp_3751() && BakedModelBufferer.isDark(level, pos, state));
        poseStack.method_22903();
        blockRenderer.method_3374(level, List.of(model), state, pos, poseStack, (class_4588)emitter, false, class_4608.field_21444);
        poseStack.method_22909();
        return emitters.end();
    }

    public static SimpleModel bufferModel(class_1087 model, class_2338 pos, class_1920 level, class_2680 state, @Nullable class_4587 poseStack, BlockMaterialFunction blockMaterialFunction) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        class_5819 random = objects.random;
        random.method_43052(state.method_26190(pos));
        List parts = model.method_68512(random);
        int size = parts.size();
        if (size == 0) {
            return new SimpleModel(List.of());
        }
        if (poseStack == null) {
            poseStack = objects.identityPoseStack;
        }
        MeshEmitterManager<VanillinMeshEmitter> emitters = objects.emitters;
        emitters.prepare(blockMaterialFunction);
        class_778 blockRenderer = class_310.method_1551().method_1541().method_3350();
        Supplier defaultLayer = Suppliers.memoize(() -> class_4696.method_23679((class_2680)state));
        class_11515 firstLayer = LayerBakedModel.getBlockRenderLayer((class_10889)parts.getFirst(), (Supplier<class_11515>)defaultLayer);
        boolean aoEnabled = class_310.method_1588();
        if (size == 1) {
            VanillinMeshEmitter emitter = emitters.getEmitter(firstLayer);
            emitter.prepareForModelLayer(aoEnabled && ((class_10889)parts.getFirst()).comp_3751() && BakedModelBufferer.isDark(level, pos, state));
            poseStack.method_22903();
            blockRenderer.method_3374(level, parts, state, pos, poseStack, (class_4588)emitter, false, class_4608.field_21444);
            poseStack.method_22909();
        } else {
            int i;
            class_11515[] renderLayers = new class_11515[size];
            boolean simple = true;
            for (i = 1; i < size; ++i) {
                renderLayers[i] = LayerBakedModel.getBlockRenderLayer((class_10889)parts.get(i), (Supplier<class_11515>)defaultLayer);
                if (!simple || renderLayers[i] == firstLayer) continue;
                simple = false;
            }
            if (simple) {
                VanillinMeshEmitter emitter = emitters.getEmitter(firstLayer);
                emitter.prepareForModelLayer(aoEnabled && ((class_10889)parts.getFirst()).comp_3751() && BakedModelBufferer.isDark(level, pos, state));
                poseStack.method_22903();
                blockRenderer.method_3374(level, parts, state, pos, poseStack, (class_4588)emitter, false, class_4608.field_21444);
                poseStack.method_22909();
            } else {
                renderLayers[0] = firstLayer;
                if (aoEnabled) {
                    aoEnabled = BakedModelBufferer.isDark(level, pos, state);
                }
                for (i = 0; i < size; ++i) {
                    class_10889 part = (class_10889)parts.get(i);
                    VanillinMeshEmitter emitter = emitters.getEmitter(renderLayers[i]);
                    emitter.prepareForModelLayer(aoEnabled && part.comp_3751());
                    poseStack.method_22903();
                    blockRenderer.method_3374(level, List.of(part), state, pos, poseStack, (class_4588)emitter, false, class_4608.field_21444);
                    poseStack.method_22909();
                }
            }
        }
        return emitters.end();
    }

    public static SimpleModel bufferBlocks(Iterator<class_2338> posIterator, class_1920 level, @Nullable class_4587 poseStack, boolean renderFluids, BlockMaterialFunction blockMaterialFunction) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        if (poseStack == null) {
            poseStack = objects.identityPoseStack;
        }
        class_5819 random = objects.random;
        MeshEmitterManager<VanillinMeshEmitter> emitters = objects.emitters;
        TransformingVertexConsumer transformingWrapper = objects.transformingWrapper;
        emitters.prepare(blockMaterialFunction);
        class_776 renderDispatcher = class_310.method_1551().method_1541();
        class_778 blockRenderer = renderDispatcher.method_3350();
        class_778.method_20544();
        boolean aoEnabled = class_310.method_1588();
        while (posIterator.hasNext()) {
            class_11515 renderType;
            class_287 bufferBuilder;
            class_3610 fluidState;
            class_2338 pos = posIterator.next();
            class_2680 state = level.method_8320(pos);
            if (renderFluids && !(fluidState = state.method_26227()).method_15769() && (bufferBuilder = emitters.getBuffer(renderType = class_4696.method_23680((class_3610)fluidState), true, false)) != null) {
                transformingWrapper.prepare((class_4588)bufferBuilder, poseStack);
                poseStack.method_22903();
                poseStack.method_46416((float)(pos.method_10263() - (pos.method_10263() & 0xF)), (float)(pos.method_10264() - (pos.method_10264() & 0xF)), (float)(pos.method_10260() - (pos.method_10260() & 0xF)));
                renderDispatcher.method_3352(pos, level, (class_4588)transformingWrapper, state, fluidState);
                poseStack.method_22909();
            }
            if (state.method_26217() != class_2464.field_11458) continue;
            class_1087 model = renderDispatcher.method_3349(state);
            random.method_43052(state.method_26190(pos));
            ObjectArrayList parts = new ObjectArrayList();
            class_1087 class_10872 = WrapperBlockStateModel.unwrapCompat(model);
            if (class_10872 instanceof WrapperBlockStateModel) {
                WrapperBlockStateModel wrapper = (WrapperBlockStateModel)class_10872;
                wrapper.addPartsWithInfo(level, pos, state, random, (List<class_10889>)parts);
            } else {
                model.method_68513(random, (List)parts);
            }
            if (parts.isEmpty()) continue;
            class_11515 renderType2 = class_4696.method_23679((class_2680)state);
            VanillinMeshEmitter emitter = emitters.getEmitter(renderType2);
            emitter.prepareForModelLayer(aoEnabled && ((class_10889)parts.getFirst()).comp_3751());
            poseStack.method_22903();
            poseStack.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            blockRenderer.method_3374(level, (List)parts, state, pos, poseStack, (class_4588)emitter, true, class_4608.field_21444);
            poseStack.method_22909();
        }
        class_778.method_20545();
        transformingWrapper.clear();
        return emitters.end();
    }

    @Environment(value=EnvType.CLIENT)
    private static class ThreadLocalObjects {
        public final class_4587 identityPoseStack = new class_4587();
        public final class_5819 random = class_5819.method_43053();
        public final MeshEmitterManager<VanillinMeshEmitter> emitters = new MeshEmitterManager(VanillinMeshEmitter::new);
        public final TransformingVertexConsumer transformingWrapper = new TransformingVertexConsumer();

        private ThreadLocalObjects() {
        }
    }
}

