/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.ponder.api.scene.PositionUtil;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.client.ponder.api.scene.SelectionUtil;
import com.zurrtum.create.client.ponder.api.scene.VectorUtil;
import com.zurrtum.create.client.ponder.foundation.SelectionImpl;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3341;

@Environment(value=EnvType.CLIENT)
public class PonderSceneBuildingUtil
implements SceneBuildingUtil {
    private final SelectionUtil select;
    private final VectorUtil vector;
    private final PositionUtil grid;
    private final class_3341 sceneBounds;

    PonderSceneBuildingUtil(class_3341 sceneBounds) {
        this.sceneBounds = sceneBounds;
        this.select = new PonderSelectionUtil();
        this.vector = new PonderVectorUtil();
        this.grid = new PonderPositionUtil();
    }

    @Override
    public SelectionUtil select() {
        return this.select;
    }

    @Override
    public VectorUtil vector() {
        return this.vector;
    }

    @Override
    public PositionUtil grid() {
        return this.grid;
    }

    @Environment(value=EnvType.CLIENT)
    public class PonderSelectionUtil
    implements SelectionUtil {
        @Override
        public Selection everywhere() {
            return SelectionImpl.of(PonderSceneBuildingUtil.this.sceneBounds);
        }

        @Override
        public Selection position(int x, int y, int z) {
            return this.position(PonderSceneBuildingUtil.this.grid().at(x, y, z));
        }

        @Override
        public Selection position(class_2338 pos) {
            return this.cuboid(pos, (class_2382)class_2338.field_10980);
        }

        @Override
        public Selection fromTo(int x, int y, int z, int x2, int y2, int z2) {
            return this.fromTo(new class_2338(x, y, z), new class_2338(x2, y2, z2));
        }

        @Override
        public Selection fromTo(class_2338 pos1, class_2338 pos2) {
            return this.cuboid(pos1, (class_2382)pos2.method_10059((class_2382)pos1));
        }

        @Override
        public Selection column(int x, int z) {
            return this.cuboid(new class_2338(x, 1, z), new class_2382(0, PonderSceneBuildingUtil.this.sceneBounds.method_14660(), 0));
        }

        @Override
        public Selection layer(int y) {
            return this.layers(y, 1);
        }

        @Override
        public Selection layersFrom(int y) {
            return this.layers(y, PonderSceneBuildingUtil.this.sceneBounds.method_14660() - y);
        }

        @Override
        public Selection layers(int y, int height) {
            return this.cuboid(new class_2338(0, y, 0), new class_2382(PonderSceneBuildingUtil.this.sceneBounds.method_35414() - 1, Math.min(PonderSceneBuildingUtil.this.sceneBounds.method_14660() - y, height) - 1, PonderSceneBuildingUtil.this.sceneBounds.method_14663() - 1));
        }

        @Override
        public Selection cuboid(class_2338 origin, class_2382 size) {
            return SelectionImpl.of(class_3341.method_34390((class_2382)origin, (class_2382)origin.method_10081(size)));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class PonderVectorUtil
    implements VectorUtil {
        @Override
        public class_243 centerOf(int x, int y, int z) {
            return this.centerOf(PonderSceneBuildingUtil.this.grid().at(x, y, z));
        }

        @Override
        public class_243 centerOf(class_2338 pos) {
            return VecHelper.getCenterOf((class_2382)pos);
        }

        @Override
        public class_243 topOf(int x, int y, int z) {
            return this.blockSurface(PonderSceneBuildingUtil.this.grid().at(x, y, z), class_2350.field_11036);
        }

        @Override
        public class_243 topOf(class_2338 pos) {
            return this.blockSurface(pos, class_2350.field_11036);
        }

        @Override
        public class_243 blockSurface(class_2338 pos, class_2350 face) {
            return this.blockSurface(pos, face, 0.0f);
        }

        @Override
        public class_243 blockSurface(class_2338 pos, class_2350 face, float margin) {
            return this.centerOf(pos).method_1019(class_243.method_24954((class_2382)face.method_62675()).method_1021((double)(0.5f + margin)));
        }

        @Override
        public class_243 of(double x, double y, double z) {
            return new class_243(x, y, z);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class PonderPositionUtil
    implements PositionUtil {
        @Override
        public class_2338 at(int x, int y, int z) {
            return new class_2338(x, y, z);
        }

        @Override
        public class_2338 zero() {
            return this.at(0, 0, 0);
        }
    }
}

