/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.compose;

import com.zurrtum.create.client.flywheel.api.visual.Visual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.vanillin.compose.ConfiguredElement;
import com.zurrtum.create.client.vanillin.compose.VisualElement;
import com.zurrtum.create.client.vanillin.compose.VisualizationPredicate;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ConfiguredElementImpl<T, C>
implements ConfiguredElement<T> {
    private final VisualElement<T, C> element;
    @Nullable
    private final C config;
    private final VisualizationPredicate<T> predicate;

    public ConfiguredElementImpl(VisualElement<T, C> element, @Nullable C config, VisualizationPredicate<T> predicate) {
        this.element = element;
        this.config = config;
        this.predicate = predicate;
    }

    @Override
    public Visual create(VisualizationContext ctx, T entity, float partialTick) {
        return this.element.create(ctx, entity, partialTick, this.config);
    }

    @Override
    public boolean shouldVisualize(VisualizationContext ctx, T entity) {
        return this.predicate.shouldVisualize(ctx, entity);
    }

    @Environment(value=EnvType.CLIENT)
    public static class ConfiguredElementBuilder<T, C> {
        private final VisualElement<T, C> element;
        @Nullable
        private C config;
        @Nullable
        private VisualizationPredicate<T> predicate;

        public ConfiguredElementBuilder(VisualElement<T, C> element) {
            this.element = element;
        }

        public ConfiguredElementBuilder<T, C> configure(@Nullable C config) {
            this.config = config;
            return this;
        }

        public ConfiguredElementBuilder<T, C> predicate(VisualizationPredicate<T> predicate) {
            this.predicate = predicate;
            return this;
        }

        public ConfiguredElement<T> build() {
            if (this.predicate == null) {
                this.predicate = VisualizationPredicate.alwaysTrue();
            }
            if (!(this.element instanceof VisualElement.Unit)) {
                Objects.requireNonNull(this.config, "Visual element requires a config but none was provided.");
            }
            return new ConfiguredElementImpl<T, C>(this.element, this.config, this.predicate);
        }
    }
}

