/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.link.controller;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.content.redstone.link.controller.LecternControllerBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_5134;
import net.minecraft.class_9288;

public class LecternControllerBlockEntity
extends SmartBlockEntity {
    private class_9288 controllerData = class_9288.field_49334;
    public UUID user;
    public UUID prevUser;
    private boolean deactivatedThisTick;

    public LecternControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.LECTERN_CONTROLLER, pos, state);
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 state) {
        super.method_66473(pos, state);
        this.dropController(state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71468("ControllerData", class_9288.field_49335, (Object)this.controllerData);
        if (this.user != null) {
            view.method_71468("User", class_4844.field_25122, (Object)this.user);
        }
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.writeSafe(view);
        view.method_71468("ControllerData", class_9288.field_49335, (Object)this.controllerData);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.controllerData = view.method_71426("ControllerData", class_9288.field_49335).orElse(class_9288.field_49334);
        this.user = view.method_71426("User", class_4844.field_25122).orElse(null);
    }

    public class_1799 getController() {
        return this.createLinkedController();
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public boolean isUsedBy(class_1657 player) {
        return this.hasUser() && this.user.equals(player.method_5667());
    }

    public void tryStartUsing(class_1657 player) {
        if (!this.deactivatedThisTick && !this.hasUser() && !LecternControllerBlockEntity.playerIsUsingLectern(player) && LecternControllerBlockEntity.playerInRange(player, this.field_11863, this.field_11867)) {
            this.startUsing(player);
        }
    }

    public void tryStopUsing(class_1657 player) {
        if (this.isUsedBy(player)) {
            this.stopUsing(player);
        }
    }

    private void startUsing(class_1657 player) {
        this.user = player.method_5667();
        AllSynchedDatas.IS_USING_LECTERN_CONTROLLER.set((class_1297)player, true);
        this.sendData();
    }

    private void stopUsing(class_1657 player) {
        this.user = null;
        if (player != null) {
            AllSynchedDatas.IS_USING_LECTERN_CONTROLLER.set((class_1297)player, false);
        }
        this.deactivatedThisTick = true;
        this.sendData();
    }

    public static boolean playerIsUsingLectern(class_1657 player) {
        return AllSynchedDatas.IS_USING_LECTERN_CONTROLLER.get((class_1297)player);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_11863.method_8608()) {
            AllClientHandle.INSTANCE.tryToggleActive(this);
            this.prevUser = this.user;
        }
        if (!this.field_11863.method_8608()) {
            this.deactivatedThisTick = false;
            if (!(this.field_11863 instanceof class_3218)) {
                return;
            }
            if (this.user == null) {
                return;
            }
            class_1297 entity = this.field_11863.method_66347(this.user);
            if (!(entity instanceof class_1657)) {
                this.stopUsing(null);
                return;
            }
            class_1657 player = (class_1657)entity;
            if (!LecternControllerBlockEntity.playerInRange(player, this.field_11863, this.field_11867) || !LecternControllerBlockEntity.playerIsUsingLectern(player)) {
                this.stopUsing(player);
            }
        }
    }

    public void setController(class_1799 newController) {
        if (newController != null) {
            this.controllerData = (class_9288)newController.method_58695(AllDataComponents.LINKED_CONTROLLER_ITEMS, (Object)class_9288.field_49334);
            AllSoundEvents.CONTROLLER_PUT.playOnServer(this.field_11863, (class_2382)this.field_11867);
        }
    }

    public void swapControllers(class_1799 stack, class_1657 player, class_1268 hand, class_2680 state) {
        class_1799 newController = stack.method_7972();
        stack.method_7939(0);
        if (player.method_5998(hand).method_7960()) {
            player.method_6122(hand, this.createLinkedController());
        } else {
            this.dropController(state);
        }
        this.setController(newController);
    }

    public void dropController(class_2680 state) {
        class_1297 entity = this.field_11863.method_66347(this.user);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            this.stopUsing(player);
        }
        class_2350 dir = (class_2350)state.method_11654((class_2769)LecternControllerBlock.field_16404);
        double x = (double)this.field_11867.method_10263() + 0.5 + 0.25 * (double)dir.method_10148();
        double y = this.field_11867.method_10264() + 1;
        double z = (double)this.field_11867.method_10260() + 0.5 + 0.25 * (double)dir.method_10165();
        class_1542 itementity = new class_1542(this.field_11863, x, y, z, this.createLinkedController());
        itementity.method_6988();
        this.field_11863.method_8649((class_1297)itementity);
        this.controllerData = class_9288.field_49334;
    }

    public static boolean playerInRange(class_1657 player, class_1937 world, class_2338 pos) {
        double reach = 0.4 * player.method_45325(class_5134.field_47758);
        return player.method_5707(class_243.method_24953((class_2382)pos)) < reach * reach;
    }

    private class_1799 createLinkedController() {
        class_1799 stack = AllItems.LINKED_CONTROLLER.method_7854();
        stack.method_57379(AllDataComponents.LINKED_CONTROLLER_ITEMS, (Object)this.controllerData);
        return stack;
    }
}

