/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.signal.SignalBoundary;
import com.zurrtum.create.content.trains.signal.SignalEdgeGroup;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.server.MinecraftServer;

public class RailwaySavedData
extends class_18 {
    public static final Codec<RailwaySavedData> CODEC = Codec.of(RailwaySavedData::save, RailwaySavedData::load);
    private static final class_10741<RailwaySavedData> TYPE = new class_10741("create_tracks", RailwaySavedData::new, CODEC, null);
    private Map<UUID, TrackGraph> trackNetworks = new HashMap<UUID, TrackGraph>();
    private Map<UUID, SignalEdgeGroup> signalEdgeGroups = new HashMap<UUID, SignalEdgeGroup>();
    private Map<UUID, Train> trains = new HashMap<UUID, Train>();

    public static <T> DataResult<T> save(RailwaySavedData input, DynamicOps<T> ops, T prefix) {
        Object empty = ops.empty();
        RecordBuilder builder = ops.mapBuilder();
        DimensionPalette dimensions = new DimensionPalette();
        ListBuilder trackNetworks = ops.listBuilder();
        for (TrackGraph trackGraph : input.trackNetworks.values()) {
            trackNetworks.add(TrackGraph.encode(trackGraph, ops, empty, dimensions));
        }
        builder.add("RailGraphs", trackNetworks.build(empty));
        ListBuilder signalEdgeGroups = ops.listBuilder();
        for (SignalEdgeGroup seg : input.signalEdgeGroups.values()) {
            if (seg.fallbackGroup && !input.trackNetworks.containsKey(seg.id)) continue;
            signalEdgeGroups.add((Object)seg, SignalEdgeGroup.CODEC);
        }
        builder.add("SignalBlocks", signalEdgeGroups.build(empty));
        ListBuilder listBuilder = ops.listBuilder();
        for (Train train : input.trains.values()) {
            listBuilder.add(Train.encode(train, ops, empty, dimensions));
        }
        builder.add("Trains", listBuilder.build(empty));
        builder.add("DimensionPalette", (Object)dimensions, DimensionPalette.CODEC);
        return builder.build(prefix);
    }

    static <T> DataResult<Pair<RailwaySavedData, T>> load(DynamicOps<T> ops, T input) {
        RailwaySavedData sd = new RailwaySavedData();
        sd.trackNetworks = new HashMap<UUID, TrackGraph>();
        sd.signalEdgeGroups = new HashMap<UUID, SignalEdgeGroup>();
        sd.trains = new HashMap<UUID, Train>();
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        DimensionPalette dimensions = (DimensionPalette)((Pair)DimensionPalette.CODEC.decode(ops, map.get("DimensionPalette")).getOrThrow()).getFirst();
        ((Consumer)ops.getList(map.get("RailGraphs")).getOrThrow()).accept(item -> {
            TrackGraph graph = TrackGraph.decode(ops, item, dimensions);
            sd.trackNetworks.put(graph.id, graph);
        });
        ((Consumer)ops.getList(map.get("SignalBlocks")).getOrThrow()).accept(item -> {
            SignalEdgeGroup group = (SignalEdgeGroup)((Pair)SignalEdgeGroup.CODEC.decode(ops, item).getOrThrow()).getFirst();
            sd.signalEdgeGroups.put(group.id, group);
        });
        ((Consumer)ops.getList(map.get("Trains")).getOrThrow()).accept(item -> {
            Train train = Train.decode(ops, item, sd.trackNetworks, dimensions);
            sd.trains.put(train.id, train);
        });
        for (TrackGraph graph : sd.trackNetworks.values()) {
            for (SignalBoundary signal : graph.getPoints(EdgePointType.SIGNAL)) {
                UUID groupId = (UUID)signal.groups.getFirst();
                UUID otherGroupId = (UUID)signal.groups.getSecond();
                if (groupId == null || otherGroupId == null) continue;
                SignalEdgeGroup group = sd.signalEdgeGroups.get(groupId);
                SignalEdgeGroup otherGroup = sd.signalEdgeGroups.get(otherGroupId);
                if (group == null || otherGroup == null) continue;
                group.putAdjacent(otherGroupId);
                otherGroup.putAdjacent(groupId);
            }
        }
        return DataResult.success((Object)Pair.of((Object)((Object)sd), (Object)ops.empty()));
    }

    public Map<UUID, TrackGraph> getTrackNetworks() {
        return this.trackNetworks;
    }

    public Map<UUID, Train> getTrains() {
        return this.trains;
    }

    public Map<UUID, SignalEdgeGroup> getSignalBlocks() {
        return this.signalEdgeGroups;
    }

    private RailwaySavedData() {
    }

    public static RailwaySavedData load(MinecraftServer server) {
        return (RailwaySavedData)server.method_30002().method_17983().method_17924(TYPE);
    }
}

