/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule.condition;

import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.schedule.condition.CargoThresholdCondition;
import java.util.Iterator;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class ItemThresholdCondition
extends CargoThresholdCondition {
    public FilterItemStack stack = FilterItemStack.empty();

    public ItemThresholdCondition(class_2960 id) {
        super(id);
    }

    @Override
    protected boolean test(class_1937 level, Train train, class_2487 context) {
        CargoThresholdCondition.Ops operator = this.getOperator();
        int target = this.getThreshold();
        boolean stacks = this.inStacks();
        int foundItems = 0;
        for (Carriage carriage : train.carriages) {
            Iterator iterator = carriage.storage.getAllItems().iterator();
            while (iterator.hasNext()) {
                class_1799 stackInSlot = (class_1799)iterator.next();
                if (!this.stack.test(level, stackInSlot)) continue;
                if (stacks) {
                    foundItems += stackInSlot.method_7947() == stackInSlot.method_7914() ? 1 : 0;
                    continue;
                }
                foundItems += stackInSlot.method_7947();
            }
        }
        this.requestStatusToUpdate(foundItems, context);
        return operator.test(foundItems, target);
    }

    @Override
    protected void writeAdditional(class_11372 view) {
        super.writeAdditional(view);
        view.method_71468("Item", FilterItemStack.CODEC, (Object)this.stack);
    }

    @Override
    protected void readAdditional(class_11368 view) {
        super.readAdditional(view);
        view.method_71426("Item", FilterItemStack.CODEC).ifPresent(stack -> {
            this.stack = stack;
        });
    }

    @Override
    public boolean tickCompletion(class_1937 level, Train train, class_2487 context) {
        return super.tickCompletion(level, train, context);
    }

    public boolean inStacks() {
        return this.intData("Measure") == 1;
    }

    @Override
    public class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag) {
        int lastDisplaySnapshot = this.getLastDisplaySnapshot(tag);
        if (lastDisplaySnapshot == -1) {
            return class_2561.method_43473();
        }
        int offset = this.getOperator() == CargoThresholdCondition.Ops.LESS ? -1 : (this.getOperator() == CargoThresholdCondition.Ops.GREATER ? 1 : 0);
        return class_2561.method_43469((String)"create.schedule.condition.threshold.status", (Object[])new Object[]{lastDisplaySnapshot, Math.max(0, this.getThreshold() + offset), class_2561.method_43471((String)("create.schedule.condition.threshold." + (this.inStacks() ? "stacks" : "items")))});
    }
}

