/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.track;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllTrackMaterials;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.trains.track.TrackBlockEntityTilt;
import com.zurrtum.create.content.trains.track.TrackMaterial;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BezierConnection
implements Iterable<Segment> {
    public static final Codec<BezierConnection> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CreateCodecs.COUPLE_BLOCK_POS_CODEC.fieldOf("Positions").forGetter(i -> i.bePositions), (App)CreateCodecs.COUPLE_VEC3D_CODEC.fieldOf("Starts").forGetter(i -> i.starts), (App)CreateCodecs.COUPLE_VEC3D_CODEC.fieldOf("Axes").forGetter(i -> i.axes), (App)CreateCodecs.COUPLE_VEC3D_CODEC.fieldOf("Normals").forGetter(i -> i.normals), (App)Codec.BOOL.fieldOf("Primary").forGetter(i -> i.primary), (App)Codec.BOOL.fieldOf("Girder").forGetter(i -> i.hasGirder), (App)TrackMaterial.CODEC.fieldOf("Material").forGetter(i -> i.trackMaterial), (App)CreateCodecs.COUPLE_INT_CODEC.optionalFieldOf("Smoothing").forGetter(i -> Optional.ofNullable(i.smoothing))).apply((Applicative)instance, BezierConnection::new));
    public final Couple<class_2338> bePositions;
    public final Couple<class_243> starts;
    public final Couple<class_243> axes;
    public final Couple<class_243> normals;
    @Nullable
    public Couple<Integer> smoothing;
    public final boolean primary;
    public final boolean hasGirder;
    protected TrackMaterial trackMaterial;
    private final AtomicReference<@Nullable Runtime> lazyRuntime = new AtomicReference<Object>(null);
    public Object bakedSegments;
    public Object bakedGirders;

    public BezierConnection(Couple<class_2338> positions, Couple<class_243> starts, Couple<class_243> axes, Couple<class_243> normals, boolean primary, boolean girder, TrackMaterial material) {
        this.bePositions = positions;
        this.starts = starts;
        this.axes = axes;
        this.normals = normals;
        this.primary = primary;
        this.hasGirder = girder;
        this.trackMaterial = material;
    }

    public BezierConnection secondary() {
        BezierConnection bezierConnection = new BezierConnection((Couple<class_2338>)this.bePositions.swap(), (Couple<class_243>)this.starts.swap(), (Couple<class_243>)this.axes.swap(), (Couple<class_243>)this.normals.swap(), !this.primary, this.hasGirder, this.trackMaterial);
        if (this.smoothing != null) {
            bezierConnection.smoothing = this.smoothing.swap();
        }
        return bezierConnection;
    }

    public BezierConnection clone() {
        BezierConnection out = new BezierConnection((Couple<class_2338>)this.bePositions.copy(), (Couple<class_243>)this.starts.copy(), (Couple<class_243>)this.axes.copy(), (Couple<class_243>)this.normals.copy(), this.primary, this.hasGirder, this.trackMaterial);
        if (this.smoothing != null) {
            out.smoothing = this.smoothing.copy();
        }
        return out;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean coupleEquals(Couple<?> a, Couple<?> b) {
        Object f;
        if (a.getFirst().equals(b.getFirst())) {
            if (a.getSecond().equals(b.getSecond())) return true;
        }
        if (!((f = a.getFirst()) instanceof class_243)) return false;
        class_243 aFirst = (class_243)f;
        Object s = a.getSecond();
        if (!(s instanceof class_243)) return false;
        class_243 aSecond = (class_243)s;
        Object f2 = b.getFirst();
        if (!(f2 instanceof class_243)) return false;
        class_243 bFirst = (class_243)f2;
        Object s2 = b.getSecond();
        if (!(s2 instanceof class_243)) return false;
        class_243 bSecond = (class_243)s2;
        if (!aFirst.method_24802((class_2374)bFirst, 1.0E-6)) return false;
        if (!aSecond.method_24802((class_2374)bSecond, 1.0E-6)) return false;
        return true;
    }

    public boolean equalsSansMaterial(BezierConnection other) {
        return this.equalsSansMaterialInner(other) || this.equalsSansMaterialInner(other.secondary());
    }

    private boolean equalsSansMaterialInner(BezierConnection other) {
        return this == other || other != null && BezierConnection.coupleEquals(this.bePositions, other.bePositions) && BezierConnection.coupleEquals(this.starts, other.starts) && BezierConnection.coupleEquals(this.axes, other.axes) && BezierConnection.coupleEquals(this.normals, other.normals) && this.hasGirder == other.hasGirder;
    }

    public BezierConnection(Couple<class_2338> bePositions, Couple<class_243> starts, Couple<class_243> axes, Couple<class_243> normals, boolean primary, boolean hasGirder, TrackMaterial trackMaterial, Optional<Couple<Integer>> smoothing) {
        this(bePositions, starts, axes, normals, primary, hasGirder, trackMaterial);
        this.smoothing = smoothing.orElse(null);
    }

    public BezierConnection(class_11368 view, class_2338 localTo) {
        this(((Couple)view.method_71426("Positions", CreateCodecs.COUPLE_BLOCK_POS_CODEC).orElseThrow()).map(b -> b.method_10081((class_2382)localTo)), ((Couple)view.method_71426("Starts", CreateCodecs.COUPLE_VEC3D_CODEC).orElseThrow()).map(v -> v.method_1019(class_243.method_24954((class_2382)localTo))), (Couple)view.method_71426("Axes", CreateCodecs.COUPLE_VEC3D_CODEC).orElseThrow(), (Couple)view.method_71426("Normals", CreateCodecs.COUPLE_VEC3D_CODEC).orElseThrow(), view.method_71433("Primary", false), view.method_71433("Girder", false), view.method_71426("Material", TrackMaterial.CODEC).orElse(AllTrackMaterials.ANDESITE));
        view.method_71426("Smoothing", CreateCodecs.COUPLE_INT_CODEC).ifPresent(couple -> {
            this.smoothing = couple;
        });
    }

    public void write(class_11372 view, class_2338 localTo) {
        Couple<class_2338> tePositions = this.bePositions.map(b -> b.method_10059((class_2382)localTo));
        Couple<class_243> starts = this.starts.map(v -> v.method_1020(class_243.method_24954((class_2382)localTo)));
        view.method_71472("Girder", this.hasGirder);
        view.method_71472("Primary", this.primary);
        view.method_71468("Positions", CreateCodecs.COUPLE_BLOCK_POS_CODEC, tePositions);
        view.method_71468("Starts", CreateCodecs.COUPLE_VEC3D_CODEC, starts);
        view.method_71468("Axes", CreateCodecs.COUPLE_VEC3D_CODEC, this.axes);
        view.method_71468("Normals", CreateCodecs.COUPLE_VEC3D_CODEC, this.normals);
        view.method_71468("Material", TrackMaterial.CODEC, (Object)this.getMaterial());
        if (this.smoothing != null) {
            view.method_71468("Smoothing", CreateCodecs.COUPLE_INT_CODEC, this.smoothing);
        }
    }

    public BezierConnection(class_2540 buffer) {
        this(Couple.create(() -> ((class_2540)buffer).method_10811()), Couple.create(() -> VecHelper.read(buffer)), Couple.create(() -> VecHelper.read(buffer)), Couple.create(() -> VecHelper.read(buffer)), buffer.readBoolean(), buffer.readBoolean(), TrackMaterial.fromId(buffer.method_10810()));
        if (buffer.readBoolean()) {
            this.smoothing = Couple.create(() -> ((class_2540)buffer).method_10816());
        }
    }

    public void write(class_2540 buffer) {
        this.bePositions.forEach(arg_0 -> ((class_2540)buffer).method_10807(arg_0));
        this.starts.forEach(v -> VecHelper.write(v, buffer));
        this.axes.forEach(v -> VecHelper.write(v, buffer));
        this.normals.forEach(v -> VecHelper.write(v, buffer));
        buffer.method_52964(this.primary);
        buffer.method_52964(this.hasGirder);
        buffer.method_10812(this.getMaterial().getId());
        buffer.method_52964(this.smoothing != null);
        if (this.smoothing != null) {
            this.smoothing.forEach(arg_0 -> ((class_2540)buffer).method_10804(arg_0));
        }
    }

    public class_2338 getKey() {
        return (class_2338)this.bePositions.getSecond();
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public int yOffsetAt(class_243 end) {
        if (this.smoothing == null) {
            return 0;
        }
        if (TrackBlockEntityTilt.compareHandles((class_243)this.starts.getFirst(), end)) {
            return (Integer)this.smoothing.getFirst();
        }
        if (TrackBlockEntityTilt.compareHandles((class_243)this.starts.getSecond(), end)) {
            return (Integer)this.smoothing.getSecond();
        }
        return 0;
    }

    public double getLength() {
        return this.resolve().length;
    }

    public float[] getStepLUT() {
        return this.resolve().stepLUT;
    }

    public int getSegmentCount() {
        return this.resolve().segments;
    }

    public class_243 getPosition(double t) {
        Runtime runtime = this.resolve();
        return VecHelper.bezier((class_243)this.starts.getFirst(), (class_243)this.starts.getSecond(), runtime.finish1, runtime.finish2, (float)t);
    }

    public double getRadius() {
        return this.resolve().radius;
    }

    public double getHandleLength() {
        return this.resolve().handleLength;
    }

    public float getSegmentT(int index) {
        return this.resolve().getSegmentT(index);
    }

    public double incrementT(double currentT, double distance) {
        Runtime runtime = this.resolve();
        double dx = VecHelper.bezierDerivative((class_243)this.starts.getFirst(), (class_243)this.starts.getSecond(), runtime.finish1, runtime.finish2, (float)currentT).method_1033() / this.getLength();
        return currentT + distance / dx;
    }

    public class_238 getBounds() {
        return this.resolve().bounds;
    }

    public class_243 getNormal(double t) {
        Runtime runtime = this.resolve();
        class_243 end1 = (class_243)this.starts.getFirst();
        class_243 end2 = (class_243)this.starts.getSecond();
        class_243 fn1 = (class_243)this.normals.getFirst();
        class_243 fn2 = (class_243)this.normals.getSecond();
        class_243 derivative = VecHelper.bezierDerivative(end1, end2, runtime.finish1, runtime.finish2, (float)t).method_1029();
        class_243 faceNormal = fn1.equals((Object)fn2) ? fn1 : VecHelper.slerp((float)t, fn1, fn2);
        class_243 normal = faceNormal.method_1036(derivative).method_1029();
        return derivative.method_1036(normal);
    }

    @NotNull
    private Runtime resolve() {
        Runtime out = this.lazyRuntime.get();
        if (out == null) {
            out = new Runtime(this.starts, this.axes);
            this.lazyRuntime.set(out);
        }
        return out;
    }

    @Override
    public Iterator<Segment> iterator() {
        class_243 offset = class_243.method_24954((class_2382)((class_2382)this.bePositions.getFirst())).method_1021(-1.0).method_1031(0.0, 0.1875, 0.0);
        return new Bezierator(this, offset);
    }

    public void addItemsToPlayer(class_1657 player) {
        class_1661 inv = player.method_31548();
        for (int tracks = this.getTrackItemCost(); tracks > 0; tracks -= 64) {
            inv.method_7398(new class_1799((class_1935)this.getMaterial().getBlock(), Math.min(64, tracks)));
        }
        for (int girders = this.getGirderItemCost(); girders > 0; girders -= 64) {
            inv.method_7398(new class_1799((class_1935)AllItems.METAL_GIRDER, Math.min(64, girders)));
        }
    }

    public int getGirderItemCost() {
        return this.hasGirder ? this.getTrackItemCost() * 2 : 0;
    }

    public int getTrackItemCost() {
        return (this.getSegmentCount() + 1) / 2;
    }

    public void spawnItems(class_1937 level) {
        class_3218 serverWorld;
        if (!(level instanceof class_3218) || !((Boolean)(serverWorld = (class_3218)level).method_64395().method_76185(class_1928.field_19392)).booleanValue()) {
            return;
        }
        class_243 origin = class_243.method_24954((class_2382)((class_2382)this.bePositions.getFirst()));
        for (Segment segment : this) {
            if (segment.index % 2 != 0 || segment.index == this.getSegmentCount()) continue;
            class_243 v = VecHelper.offsetRandomly(segment.position, level.field_9229, 0.125f).method_1019(origin);
            class_1542 entity = new class_1542(level, v.field_1352, v.field_1351, v.field_1350, new class_1799((class_1935)this.getMaterial()));
            entity.method_6988();
            level.method_8649((class_1297)entity);
            if (!this.hasGirder) continue;
            for (int i = 0; i < 2; ++i) {
                entity = new class_1542(level, v.field_1352, v.field_1351, v.field_1350, AllItems.METAL_GIRDER.method_7854());
                entity.method_6988();
                level.method_8649((class_1297)entity);
            }
        }
    }

    public void spawnDestroyParticles(class_1937 level) {
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 slevel = (class_3218)level;
        class_2388 data = new class_2388(class_2398.field_11217, this.getMaterial().getBlock().method_9564());
        class_2388 girderData = new class_2388(class_2398.field_11217, AllBlocks.METAL_GIRDER.method_9564());
        class_243 origin = class_243.method_24954((class_2382)((class_2382)this.bePositions.getFirst()));
        for (Segment segment : this) {
            for (int offset : Iterate.positiveAndNegative) {
                class_243 v = segment.position.method_1019(segment.normal.method_1021((double)(0.875f * (float)offset))).method_1019(origin);
                slevel.method_65096((class_2394)data, v.field_1352, v.field_1351, v.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                if (!this.hasGirder) continue;
                slevel.method_65096((class_2394)girderData, v.field_1352, v.field_1351 - 0.5, v.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public TrackMaterial getMaterial() {
        return this.trackMaterial;
    }

    public void setMaterial(TrackMaterial material) {
        this.trackMaterial = material;
    }

    public <T> T getBakedSegments(Function<BezierConnection, T> factory) {
        if (this.bakedSegments != null) {
            return (T)this.bakedSegments;
        }
        T segments = factory.apply(this);
        this.bakedSegments = segments;
        return segments;
    }

    public <T> T getBakedGirders(Function<BezierConnection, T> factory) {
        if (this.bakedGirders != null) {
            return (T)this.bakedGirders;
        }
        T girders = factory.apply(this);
        this.bakedGirders = girders;
        return girders;
    }

    public Map<Pair<Integer, Integer>, Double> rasterise() {
        HashMap<Pair<Integer, Integer>, Double> yLevels = new HashMap<Pair<Integer, Integer>, Double>();
        class_2338 tePosition = (class_2338)this.bePositions.getFirst();
        class_243 end1 = ((class_243)this.starts.getFirst()).method_1020(class_243.method_24954((class_2382)tePosition)).method_1031(0.0, 0.1875, 0.0);
        class_243 end2 = ((class_243)this.starts.getSecond()).method_1020(class_243.method_24954((class_2382)tePosition)).method_1031(0.0, 0.1875, 0.0);
        class_243 axis1 = (class_243)this.axes.getFirst();
        class_243 axis2 = (class_243)this.axes.getSecond();
        double handleLength = this.getHandleLength();
        class_243 finish1 = axis1.method_1021(handleLength).method_1019(end1);
        class_243 finish2 = axis2.method_1021(handleLength).method_1019(end2);
        class_243 faceNormal1 = (class_243)this.normals.getFirst();
        class_243 faceNormal2 = (class_243)this.normals.getSecond();
        int segCount = this.getSegmentCount();
        float[] lut = this.getStepLUT();
        class_243[] samples = new class_243[segCount];
        for (int i = 0; i < segCount; ++i) {
            class_243 railMiddle;
            float t = class_3532.method_15363((float)(((float)i + 0.5f) * lut[i] / (float)segCount), (float)0.0f, (float)1.0f);
            class_243 result = VecHelper.bezier(end1, end2, finish1, finish2, t);
            class_243 derivative = VecHelper.bezierDerivative(end1, end2, finish1, finish2, t).method_1029();
            class_243 faceNormal = faceNormal1.equals((Object)faceNormal2) ? faceNormal1 : VecHelper.slerp(t, faceNormal1, faceNormal2);
            class_243 normal = faceNormal.method_1036(derivative).method_1029();
            class_243 below = result.method_1019(faceNormal.method_1021(-0.25));
            class_243 rail1 = below.method_1019(normal.method_1021((double)0.05f));
            class_243 rail2 = below.method_1020(normal.method_1021((double)0.05f));
            samples[i] = railMiddle = rail1.method_1019(rail2).method_1021(0.5);
        }
        class_243 center = end1.method_1019(end2).method_1021(0.5);
        Pair<Integer, Integer> prev = null;
        Pair<Integer, Integer> prev2 = null;
        Pair<Integer, Integer> prev3 = null;
        for (int i = 0; i < segCount; ++i) {
            class_243 railMiddle = samples[i];
            class_2338 pos = class_2338.method_49638((class_2374)railMiddle);
            Pair<Integer, Integer> key = Pair.of(pos.method_10263(), pos.method_10260());
            boolean alreadyPresent = yLevels.containsKey(key);
            if (alreadyPresent && (Double)yLevels.get(key) <= railMiddle.field_1351) continue;
            yLevels.put(key, railMiddle.field_1351);
            if (alreadyPresent) continue;
            if (prev3 != null) {
                boolean prevCloser;
                boolean doubledViaPrev = this.isLineDoubled(prev2, prev, key);
                boolean doubledViaPrev2 = this.isLineDoubled(prev3, prev2, prev);
                boolean bl = prevCloser = this.diff(prev, center) > this.diff(prev2, center);
                if (!(!doubledViaPrev2 || doubledViaPrev && prevCloser)) {
                    yLevels.remove(prev2);
                    prev2 = prev;
                    prev = key;
                    continue;
                }
                if (doubledViaPrev && doubledViaPrev2 && prevCloser) {
                    yLevels.remove(prev);
                    prev = key;
                    continue;
                }
            }
            prev3 = prev2;
            prev2 = prev;
            prev = key;
        }
        return yLevels;
    }

    private double diff(Pair<Integer, Integer> pFrom, class_243 to) {
        return to.method_1028((double)pFrom.getFirst().intValue() + 0.5, to.field_1351, (double)pFrom.getSecond().intValue() + 0.5);
    }

    private boolean isLineDoubled(Pair<Integer, Integer> pFrom, Pair<Integer, Integer> pVia, Pair<Integer, Integer> pTo) {
        int diff1x = pVia.getFirst() - pFrom.getFirst();
        int diff1z = pVia.getSecond() - pFrom.getSecond();
        int diff2x = pTo.getFirst() - pVia.getFirst();
        int diff2z = pTo.getSecond() - pVia.getSecond();
        return Math.abs(diff1x) + Math.abs(diff1z) == 1 && Math.abs(diff2x) + Math.abs(diff2z) == 1 && diff1x != diff2x && diff1z != diff2z;
    }

    private static class Runtime {
        private final class_243 finish1;
        private final class_243 finish2;
        private final double length;
        private final float[] stepLUT;
        private final int segments;
        private double radius;
        private double handleLength;
        private final class_238 bounds;

        private Runtime(Couple<class_243> starts, Couple<class_243> axes) {
            class_243 end1 = (class_243)starts.getFirst();
            class_243 end2 = (class_243)starts.getSecond();
            class_243 axis1 = ((class_243)axes.getFirst()).method_1029();
            class_243 axis2 = ((class_243)axes.getSecond()).method_1029();
            this.determineHandles(end1, end2, axis1, axis2);
            this.finish1 = axis1.method_1021(this.handleLength).method_1019(end1);
            this.finish2 = axis2.method_1021(this.handleLength).method_1019(end2);
            int scanCount = 16;
            this.length = Runtime.computeLength(this.finish1, this.finish2, end1, end2, scanCount);
            this.segments = (int)(this.length * 2.0);
            this.stepLUT = new float[this.segments + 1];
            this.stepLUT[0] = 1.0f;
            float combinedDistance = 0.0f;
            class_238 bounds = new class_238(end1, end2);
            class_243 previous = end1;
            for (int i = 0; i <= this.segments; ++i) {
                float t = (float)i / (float)this.segments;
                class_243 result = VecHelper.bezier(end1, end2, this.finish1, this.finish2, t);
                bounds = bounds.method_991(new class_238(result, result));
                if (i > 0) {
                    combinedDistance = (float)((double)combinedDistance + result.method_1022(previous) / this.length);
                    this.stepLUT[i] = t / combinedDistance;
                }
                previous = result;
            }
            this.bounds = bounds.method_1014(1.375);
        }

        private static double computeLength(class_243 finish1, class_243 finish2, class_243 end1, class_243 end2, int scanCount) {
            double length = 0.0;
            class_243 previous = end1;
            for (int i = 0; i <= scanCount; ++i) {
                float t = (float)i / (float)scanCount;
                class_243 result = VecHelper.bezier(end1, end2, finish1, finish2, t);
                if (previous != null) {
                    length += result.method_1022(previous);
                }
                previous = result;
            }
            return length;
        }

        public float getSegmentT(int index) {
            return index == this.segments ? 1.0f : (float)index * this.stepLUT[index] / (float)this.segments;
        }

        private void determineHandles(class_243 end1, class_243 end2, class_243 axis1, class_243 axis2) {
            class_243 cross1 = axis1.method_1036(new class_243(0.0, 1.0, 0.0));
            class_243 cross2 = axis2.method_1036(new class_243(0.0, 1.0, 0.0));
            this.radius = 0.0;
            double a1 = class_3532.method_15349((double)(-axis2.field_1350), (double)(-axis2.field_1352));
            double a2 = class_3532.method_15349((double)axis1.field_1350, (double)axis1.field_1352);
            double angle = a1 - a2;
            float circle = (float)Math.PI * 2;
            if (Math.abs((double)circle - (angle = (angle + (double)circle) % (double)circle)) < Math.abs(angle)) {
                angle = (double)circle - angle;
            }
            if (class_3532.method_20390((double)angle, (double)0.0)) {
                double[] intersect = VecHelper.intersect(end1, end2, axis1, cross2, class_2350.class_2351.field_11052);
                if (intersect != null) {
                    double t = Math.abs(intersect[0]);
                    double u = Math.abs(intersect[1]);
                    double min = Math.min(t, u);
                    double max = Math.max(t, u);
                    if (min > 1.2 && max / min > 1.0 && max / min < 3.0) {
                        this.handleLength = max - min;
                        return;
                    }
                }
                this.handleLength = end2.method_1022(end1) / 3.0;
                return;
            }
            double n = (double)circle / angle;
            double factor = 1.3333333333333333 * Math.tan(Math.PI / (2.0 * n));
            double[] intersect = VecHelper.intersect(end1, end2, cross1, cross2, class_2350.class_2351.field_11052);
            if (intersect == null) {
                this.handleLength = end2.method_1022(end1) / 3.0;
                return;
            }
            this.radius = Math.abs(intersect[1]);
            this.handleLength = this.radius * factor;
            if (class_3532.method_20390((double)this.handleLength, (double)0.0)) {
                this.handleLength = 1.0;
            }
        }
    }

    private static class Bezierator
    implements Iterator<Segment> {
        private final Segment segment;
        private final class_243 end1;
        private final class_243 end2;
        private final class_243 finish1;
        private final class_243 finish2;
        private final class_243 faceNormal1;
        private final class_243 faceNormal2;
        private final Runtime runtime;

        private Bezierator(BezierConnection bc, class_243 offset) {
            this.runtime = bc.resolve();
            this.end1 = ((class_243)bc.starts.getFirst()).method_1019(offset);
            this.end2 = ((class_243)bc.starts.getSecond()).method_1019(offset);
            this.finish1 = ((class_243)bc.axes.getFirst()).method_1021(this.runtime.handleLength).method_1019(this.end1);
            this.finish2 = ((class_243)bc.axes.getSecond()).method_1021(this.runtime.handleLength).method_1019(this.end2);
            this.faceNormal1 = (class_243)bc.normals.getFirst();
            this.faceNormal2 = (class_243)bc.normals.getSecond();
            this.segment = new Segment();
            this.segment.index = -1;
        }

        @Override
        public boolean hasNext() {
            return this.segment.index + 1 <= this.runtime.segments;
        }

        @Override
        public Segment next() {
            ++this.segment.index;
            float t = this.runtime.getSegmentT(this.segment.index);
            this.segment.position = VecHelper.bezier(this.end1, this.end2, this.finish1, this.finish2, t);
            this.segment.derivative = VecHelper.bezierDerivative(this.end1, this.end2, this.finish1, this.finish2, t).method_1029();
            this.segment.faceNormal = this.faceNormal1.equals((Object)this.faceNormal2) ? this.faceNormal1 : VecHelper.slerp(t, this.faceNormal1, this.faceNormal2);
            this.segment.normal = this.segment.faceNormal.method_1036(this.segment.derivative).method_1029();
            return this.segment;
        }
    }

    public static class Segment {
        public int index;
        public class_243 position;
        public class_243 derivative;
        public class_243 faceNormal;
        public class_243 normal;
    }
}

