/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.villagernames_common_forge.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import com.natamus.villagernames_common_forge.util.Util;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.permissions.Permissions;

public class CommandVillagernames {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"villagernames").requires(iCommandSender -> iCommandSender.permissions().hasPermission(Permissions.COMMANDS_ADMIN))).executes(command -> {
            CommandVillagernames.sendUsage((CommandSourceStack)command.getSource());
            return 1;
        })).then(Commands.literal((String)"unname").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            int count = Util.unnameLoadedVillagers(source.getLevel());
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)("The names of " + count + " loaded villagers have been removed."), (ChatFormatting)ChatFormatting.DARK_GREEN);
            return 1;
        }))).then(Commands.literal((String)"name").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            int count = Util.nameLoadedVillagers(source.getLevel());
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)(count + " loaded villagers without a name have been named."), (ChatFormatting)ChatFormatting.DARK_GREEN);
            return 1;
        }))).then(Commands.literal((String)"rename").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            int count = Util.renameLoadedVillagers(source.getLevel());
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)(count + " loaded villagers have been renamed."), (ChatFormatting)ChatFormatting.DARK_GREEN);
            return 1;
        })));
    }

    public static void sendUsage(CommandSourceStack source) {
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"--- Villager Names Commands Usage ---", (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /villagernames unname", (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"  Removes the names of all loaded villagers.", (ChatFormatting)ChatFormatting.DARK_GRAY);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /villagernames name", (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"  Gives all unnamed loaded villagers a name.", (ChatFormatting)ChatFormatting.DARK_GRAY);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /villagernames rename", (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"  Gives all loaded villagers a new random name.", (ChatFormatting)ChatFormatting.DARK_GRAY);
    }
}

