/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.network;

import fr.rakambda.fallingtree.common.config.IConfiguration;
import fr.rakambda.fallingtree.common.config.enums.BreakMode;
import fr.rakambda.fallingtree.common.wrapper.IFriendlyByteBuf;
import lombok.Generated;
import org.jspecify.annotations.NonNull;

public class ConfigurationPacket {
    private boolean dedicated;
    private double speedMultiplicand;
    private boolean forceToolUsage;
    private BreakMode breakMode;

    public static ConfigurationPacket get(boolean dedicated, @NonNull IConfiguration configuration) {
        return ConfigurationPacket.builder().dedicated(dedicated).speedMultiplicand(configuration.getTools().getSpeedMultiplicand()).forceToolUsage(configuration.getTools().isForceToolUsage()).breakMode(configuration.getTrees().getBreakMode()).build();
    }

    public void write(IFriendlyByteBuf buf) {
        buf.writeBoolean(this.isDedicated());
        buf.writeDouble(this.getSpeedMultiplicand());
        buf.writeBoolean(this.isForceToolUsage());
        buf.writeInteger(this.getBreakMode().ordinal());
    }

    public static ConfigurationPacket read(IFriendlyByteBuf buf) {
        return ConfigurationPacket.builder().dedicated(buf.readBoolean()).speedMultiplicand(buf.readDouble()).forceToolUsage(buf.readBoolean()).breakMode(BreakMode.getValues()[buf.readInteger()]).build();
    }

    @Generated
    public static ConfigurationPacketBuilder builder() {
        return new ConfigurationPacketBuilder();
    }

    @Generated
    public boolean isDedicated() {
        return this.dedicated;
    }

    @Generated
    public double getSpeedMultiplicand() {
        return this.speedMultiplicand;
    }

    @Generated
    public boolean isForceToolUsage() {
        return this.forceToolUsage;
    }

    @Generated
    public BreakMode getBreakMode() {
        return this.breakMode;
    }

    @Generated
    public void setDedicated(boolean dedicated) {
        this.dedicated = dedicated;
    }

    @Generated
    public void setSpeedMultiplicand(double speedMultiplicand) {
        this.speedMultiplicand = speedMultiplicand;
    }

    @Generated
    public void setForceToolUsage(boolean forceToolUsage) {
        this.forceToolUsage = forceToolUsage;
    }

    @Generated
    public void setBreakMode(BreakMode breakMode) {
        this.breakMode = breakMode;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigurationPacket)) {
            return false;
        }
        ConfigurationPacket other = (ConfigurationPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDedicated() != other.isDedicated()) {
            return false;
        }
        if (Double.compare(this.getSpeedMultiplicand(), other.getSpeedMultiplicand()) != 0) {
            return false;
        }
        if (this.isForceToolUsage() != other.isForceToolUsage()) {
            return false;
        }
        BreakMode this$breakMode = this.getBreakMode();
        BreakMode other$breakMode = other.getBreakMode();
        return !(this$breakMode == null ? other$breakMode != null : !((Object)((Object)this$breakMode)).equals((Object)other$breakMode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfigurationPacket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDedicated() ? 79 : 97);
        long $speedMultiplicand = Double.doubleToLongBits(this.getSpeedMultiplicand());
        result = result * 59 + (int)($speedMultiplicand >>> 32 ^ $speedMultiplicand);
        result = result * 59 + (this.isForceToolUsage() ? 79 : 97);
        BreakMode $breakMode = this.getBreakMode();
        result = result * 59 + ($breakMode == null ? 43 : ((Object)((Object)$breakMode)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConfigurationPacket(dedicated=" + this.isDedicated() + ", speedMultiplicand=" + this.getSpeedMultiplicand() + ", forceToolUsage=" + this.isForceToolUsage() + ", breakMode=" + String.valueOf((Object)this.getBreakMode()) + ")";
    }

    @Generated
    public ConfigurationPacket() {
    }

    @Generated
    public ConfigurationPacket(boolean dedicated, double speedMultiplicand, boolean forceToolUsage, BreakMode breakMode) {
        this.dedicated = dedicated;
        this.speedMultiplicand = speedMultiplicand;
        this.forceToolUsage = forceToolUsage;
        this.breakMode = breakMode;
    }

    @Generated
    public static class ConfigurationPacketBuilder {
        @Generated
        private boolean dedicated;
        @Generated
        private double speedMultiplicand;
        @Generated
        private boolean forceToolUsage;
        @Generated
        private BreakMode breakMode;

        @Generated
        ConfigurationPacketBuilder() {
        }

        @Generated
        public ConfigurationPacketBuilder dedicated(boolean dedicated) {
            this.dedicated = dedicated;
            return this;
        }

        @Generated
        public ConfigurationPacketBuilder speedMultiplicand(double speedMultiplicand) {
            this.speedMultiplicand = speedMultiplicand;
            return this;
        }

        @Generated
        public ConfigurationPacketBuilder forceToolUsage(boolean forceToolUsage) {
            this.forceToolUsage = forceToolUsage;
            return this;
        }

        @Generated
        public ConfigurationPacketBuilder breakMode(BreakMode breakMode) {
            this.breakMode = breakMode;
            return this;
        }

        @Generated
        public ConfigurationPacket build() {
            return new ConfigurationPacket(this.dedicated, this.speedMultiplicand, this.forceToolUsage, this.breakMode);
        }

        @Generated
        public String toString() {
            return "ConfigurationPacket.ConfigurationPacketBuilder(dedicated=" + this.dedicated + ", speedMultiplicand=" + this.speedMultiplicand + ", forceToolUsage=" + this.forceToolUsage + ", breakMode=" + String.valueOf((Object)this.breakMode) + ")";
        }
    }
}

