/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.forge.common;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.config.enums.BreakMode;
import fr.rakambda.fallingtree.common.leaf.LeafBreakingHandler;
import fr.rakambda.fallingtree.common.network.ServerPacketHandler;
import fr.rakambda.fallingtree.common.utils.BoundedList;
import fr.rakambda.fallingtree.common.wrapper.DirectionCompat;
import fr.rakambda.fallingtree.common.wrapper.IBlock;
import fr.rakambda.fallingtree.common.wrapper.IBlockBreakEvent;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.IComponent;
import fr.rakambda.fallingtree.common.wrapper.IItem;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import fr.rakambda.fallingtree.forge.FallingTreeUtils;
import fr.rakambda.fallingtree.forge.client.event.PlayerLeaveListener;
import fr.rakambda.fallingtree.forge.common.wrapper.BlockWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.ComponentWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.ItemStackWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.ItemWrapper;
import fr.rakambda.fallingtree.forge.event.BlockBreakListener;
import fr.rakambda.fallingtree.forge.event.LeafBreakingListener;
import fr.rakambda.fallingtree.forge.event.ServerCommandRegistrationListener;
import fr.rakambda.fallingtree.forge.network.ForgePacketHandler;
import fr.rakambda.fallingtree.forge.network.PlayerJoinListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.util.Result;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.internal.Event;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jspecify.annotations.NonNull;

public class FallingTreeCommonsImpl
extends FallingTreeCommon<Direction> {
    private final LeafBreakingHandler leafBreakingHandler = new LeafBreakingHandler(this);
    private final ForgePacketHandler packetHandler = new ForgePacketHandler();
    private final TagKey<Enchantment> chopperEnchantmentTag;
    private final Map<BreakMode, TagKey<Enchantment>> breakModeChopperEnchantmentTag;
    private final List<BlockEvent.BreakEvent> breakEvents;
    private final Map<IBlock, Boolean> isLogBlockCache = new HashMap<IBlock, Boolean>();
    private final Map<IBlock, Boolean> isLeafBlockCache = new HashMap<IBlock, Boolean>();
    private final Map<IBlock, Boolean> isWartBlockCache = new HashMap<IBlock, Boolean>();

    public FallingTreeCommonsImpl() {
        this.chopperEnchantmentTag = TagKey.create((ResourceKey)Registries.ENCHANTMENT, (Identifier)FallingTreeUtils.id("chopper_all"));
        this.breakModeChopperEnchantmentTag = new HashMap<BreakMode, TagKey<Enchantment>>();
        this.breakModeChopperEnchantmentTag.put(BreakMode.FALL_ALL_BLOCK, (TagKey<Enchantment>)TagKey.create((ResourceKey)Registries.ENCHANTMENT, (Identifier)FallingTreeUtils.id("chopper_fall_all_block")));
        this.breakModeChopperEnchantmentTag.put(BreakMode.FALL_BLOCK, (TagKey<Enchantment>)TagKey.create((ResourceKey)Registries.ENCHANTMENT, (Identifier)FallingTreeUtils.id("chopper_fall_block")));
        this.breakModeChopperEnchantmentTag.put(BreakMode.FALL_ITEM, (TagKey<Enchantment>)TagKey.create((ResourceKey)Registries.ENCHANTMENT, (Identifier)FallingTreeUtils.id("chopper_fall_item")));
        this.breakModeChopperEnchantmentTag.put(BreakMode.INSTANTANEOUS, (TagKey<Enchantment>)TagKey.create((ResourceKey)Registries.ENCHANTMENT, (Identifier)FallingTreeUtils.id("chopper_instantaneous")));
        this.breakModeChopperEnchantmentTag.put(BreakMode.SHIFT_DOWN, (TagKey<Enchantment>)TagKey.create((ResourceKey)Registries.ENCHANTMENT, (Identifier)FallingTreeUtils.id("chopper_shift_down")));
        this.breakEvents = new BoundedList<BlockEvent.BreakEvent>(50);
    }

    @Override
    public @NonNull IComponent translate(@NonNull String key, Object ... objects) {
        Object[] vars = Arrays.stream(objects).map(o -> {
            if (o instanceof IComponent) {
                IComponent component = (IComponent)o;
                return component.getRaw();
            }
            return o;
        }).toArray();
        return new ComponentWrapper(Component.translatable((String)key, (Object[])vars));
    }

    @Override
    public @NonNull ServerPacketHandler getServerPacketHandler() {
        return this.packetHandler;
    }

    @Override
    public @NonNull Stream<IBlock> getBlock(@NonNull String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            Identifier resourceLocation = FallingTreeUtils.idExternal(name);
            if (isTag) {
                TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (Identifier)resourceLocation);
                return this.getRegistryTagContent((Registry)BuiltInRegistries.BLOCK, (TagKey)tag).map(BlockWrapper::new);
            }
            return this.getRegistryElement((Registry)BuiltInRegistries.BLOCK, resourceLocation).stream().map(BlockWrapper::new);
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    @Override
    public @NonNull Stream<IItem> getItem(@NonNull String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            Identifier resourceLocation = FallingTreeUtils.idExternal(name);
            if (isTag) {
                TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (Identifier)resourceLocation);
                return this.getRegistryTagContent((Registry)BuiltInRegistries.ITEM, (TagKey)tag).map(ItemWrapper::new);
            }
            return this.getRegistryElement((Registry)BuiltInRegistries.ITEM, resourceLocation).stream().map(ItemWrapper::new);
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    @Override
    public boolean isLeafBlock(@NonNull IBlock block) {
        return this.isLeafBlockCache.computeIfAbsent(block, Key -> {
            boolean isAllowedBlock;
            boolean bl = isAllowedBlock = this.registryTagContains((Registry)BuiltInRegistries.BLOCK, (TagKey)BlockTags.LEAVES, (Object)((Block)block.getRaw())) || this.getConfiguration().getTrees().getAllowedLeaveBlocks(this).stream().anyMatch(leaf -> leaf.equals(block));
            if (isAllowedBlock) {
                boolean isDeniedBlock = this.getConfiguration().getTrees().getDeniedLeaveBlocks(this).stream().anyMatch(leaf -> leaf.equals(block));
                return !isDeniedBlock;
            }
            return false;
        });
    }

    @Override
    public boolean isLogBlock(@NonNull IBlock block) {
        return this.isLogBlockCache.computeIfAbsent(block, Key -> {
            boolean isAllowedBlock;
            boolean bl = isAllowedBlock = this.getConfiguration().getTrees().getDefaultLogsBlocks(this).stream().anyMatch(log -> log.equals(block)) || this.getConfiguration().getTrees().getAllowedLogBlocks(this).stream().anyMatch(log -> log.equals(block));
            if (isAllowedBlock) {
                boolean isDeniedBlock = this.getConfiguration().getTrees().getDeniedLogBlocks(this).stream().anyMatch(log -> log.equals(block));
                return !isDeniedBlock;
            }
            return false;
        });
    }

    @Override
    public @NonNull Set<IBlock> getAllNonStrippedLogsBlocks() {
        return this.getRegistryTagContent((Registry)BuiltInRegistries.BLOCK, (TagKey)BlockTags.LOGS).filter(block -> Optional.of(BuiltInRegistries.BLOCK.getKey(block)).map(Identifier::getPath).map(name -> name.startsWith("stripped")).orElse(false) == false).map(BlockWrapper::new).collect(Collectors.toSet());
    }

    @Override
    public @NonNull DirectionCompat asDirectionCompat(@NonNull Direction dir) {
        return DirectionCompat.valueOf(dir.name());
    }

    @Override
    public @NonNull Direction asDirection(@NonNull DirectionCompat dir) {
        return Direction.valueOf((String)dir.name());
    }

    @Override
    public boolean isNetherWartOrShroomlight(@NonNull IBlock block) {
        return this.isWartBlockCache.computeIfAbsent(block, Key -> this.registryTagContains((Registry)BuiltInRegistries.BLOCK, (TagKey)BlockTags.WART_BLOCKS, (Object)((Block)block.getRaw())) || Blocks.SHROOMLIGHT.equals(block.getRaw()));
    }

    @Override
    public boolean isMangroveRoots(@NonNull IBlock block) {
        return Blocks.MANGROVE_ROOTS.equals(block.getRaw());
    }

    @Override
    public boolean checkCanBreakBlock(@NonNull ILevel level, @NonNull IBlockPos blockPos, @NonNull IBlockState blockState, @NonNull IPlayer player) {
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent((Level)level.getRaw(), (BlockPos)blockPos.getRaw(), (BlockState)blockState.getRaw(), (Player)player.getRaw(), Result.DEFAULT);
        this.breakEvents.add(event);
        return !BlockEvent.BreakEvent.BUS.post((Event)event);
    }

    @Override
    public boolean isOwnEvent(@NonNull IBlockBreakEvent event) {
        boolean result = this.breakEvents.contains((BlockEvent.BreakEvent)event.getRaw());
        if (result) {
            this.breakEvents.remove((BlockEvent.BreakEvent)event.getRaw());
        }
        return result;
    }

    @Override
    public @NonNull IItemStack getEmptyItemStack() {
        return new ItemStackWrapper(ItemStack.EMPTY);
    }

    @Override
    public void onConfigUpdate() {
        this.isLogBlockCache.clear();
        this.isLeafBlockCache.clear();
        this.isWartBlockCache.clear();
    }

    private <T> @NonNull Optional<T> getRegistryElement(Registry<T> registryKey, Identifier identifier) {
        return registryKey.get(identifier).map(Holder::value);
    }

    private <T> @NonNull Stream<T> getRegistryTagContent(@NonNull Registry<T> registry, @NonNull TagKey<T> tag) {
        return registry.get(tag).stream().flatMap(a -> a.stream().map(Holder::value));
    }

    private <T> boolean registryTagContains(@NonNull Registry<T> registry, @NonNull TagKey<T> tag, @NonNull T element) {
        return this.getRegistryTagContent(registry, tag).anyMatch(element::equals);
    }

    public void registerForge() {
        this.getServerPacketHandler().registerServer();
        BlockBreakListener blockBreakListener = new BlockBreakListener(this);
        BlockEvent.BreakEvent.BUS.addListener(blockBreakListener::onBlockBreakEvent);
        PlayerEvent.BreakSpeed.BUS.addListener(blockBreakListener::onBreakSpeed);
        LeafBreakingListener leafBreakingListener = new LeafBreakingListener(this);
        TickEvent.ServerTickEvent.Post.BUS.addListener(leafBreakingListener::onServerTick);
        BlockEvent.NeighborNotifyEvent.BUS.addListener(leafBreakingListener::onNeighborNotifyEvent);
        LevelEvent.Unload.BUS.addListener(leafBreakingListener::onWorldUnload);
        PlayerJoinListener playerJoinListener = new PlayerJoinListener(this);
        PlayerEvent.PlayerLoggedInEvent.BUS.addListener(playerJoinListener::onPlayerLoggedInEvent);
        PlayerLeaveListener playerLeaveListener = new PlayerLeaveListener(this);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientPlayerNetworkEvent.LoggingOut.BUS.addListener(playerLeaveListener::onPlayerLoggedOutEvent);
        }
        ServerCommandRegistrationListener serverCommandRegistrationListener = new ServerCommandRegistrationListener(this);
        RegisterCommandsEvent.BUS.addListener(serverCommandRegistrationListener::onRegisterCommands);
    }

    @Override
    @Generated
    public LeafBreakingHandler getLeafBreakingHandler() {
        return this.leafBreakingHandler;
    }

    @Generated
    public TagKey<Enchantment> getChopperEnchantmentTag() {
        return this.chopperEnchantmentTag;
    }

    @Generated
    public Map<BreakMode, TagKey<Enchantment>> getBreakModeChopperEnchantmentTag() {
        return this.breakModeChopperEnchantmentTag;
    }
}

